/*
 * Decompiled with CFR 0.152.
 */
package phex.net.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import phex.common.ServiceManager;
import phex.common.address.DestAddress;
import phex.utils.IOUtil;

public class NIOSocketFactory {
    private NIOSocketFactory() {
    }

    public static Socket connectNIO(DestAddress address) throws IOException {
        return NIOSocketFactory.connectNIO(address.getHostName(), address.getPort(), ServiceManager.sCfg.socketConnectTimeout);
    }

    public static Socket connectNIO(DestAddress address, int connectTimeout) throws IOException {
        return NIOSocketFactory.connectNIO(address.getHostName(), address.getPort(), connectTimeout);
    }

    public static Socket connectNIO(String host, int port, int connectTimeout) throws IOException {
        if (port < 0 || port > 65535) {
            throw new IOException("Wrong host address (port out of range: " + port + " )");
        }
        if (ServiceManager.sCfg.mProxyUse) {
            return NIOSocketFactory.connectSock5NIO(host, port);
        }
        SocketChannel channel = SocketChannel.open();
        channel.configureBlocking(true);
        Socket socket = channel.socket();
        socket.connect(new InetSocketAddress(host, port), connectTimeout);
        socket.setSoTimeout(ServiceManager.sCfg.socketRWTimeout);
        return socket;
    }

    private static Socket connectSock5NIO(String host, int port) throws IOException {
        Socket socket = null;
        InputStream is = null;
        OutputStream os = null;
        try {
            SocketChannel channel = SocketChannel.open();
            channel.configureBlocking(true);
            socket = channel.socket();
            socket.connect(new InetSocketAddress(ServiceManager.sCfg.mProxyHost, ServiceManager.sCfg.mProxyPort), ServiceManager.sCfg.socketConnectTimeout);
            socket.setSoTimeout(ServiceManager.sCfg.socketRWTimeout);
            is = socket.getInputStream();
            os = socket.getOutputStream();
            byte[] header = ServiceManager.sCfg.mProxyUserName.length() > 0 ? new byte[]{5, 2, 0, 2} : new byte[]{5, 1, 0};
            os.write(header, 0, header.length);
            int servVersion = is.read();
            if (servVersion != 5) {
                throw new IOException("Invalid SOCKS server version: " + servVersion);
            }
            byte servMethod = (byte)is.read();
            if (servMethod == -1) {
                throw new IOException("SOCKS: No acceptable authentication.");
            }
            if (servMethod != 0) {
                if (servMethod == 2) {
                    NIOSocketFactory.authenticateUserPassword(is, os);
                } else {
                    throw new IOException("Unknown SOCKS5 authentication method required.");
                }
            }
            byte[] request = new byte[10];
            request[0] = 5;
            request[1] = 1;
            request[2] = 0;
            request[3] = 1;
            IOUtil.serializeIP(host, request, 4);
            request[8] = (byte)(port >> 8);
            request[9] = (byte)port;
            os.write(request, 0, request.length);
            int version = is.read();
            int status = is.read();
            is.read();
            int atype = is.read();
            if (atype == 1) {
                is.read();
                is.read();
                is.read();
                is.read();
            } else if (atype == 3) {
                int len = is.read();
                if (len < 0) {
                    len += 256;
                }
                while (len > 0) {
                    is.read();
                    --len;
                }
            } else if (atype == 4) {
                for (int i = 0; i < 16; ++i) {
                    is.read();
                }
            } else {
                throw new IOException("Invalid return address type for SOCKS5");
            }
            is.read();
            is.read();
            if (version != 5) {
                throw new IOException("Invalid SOCKS server version: " + version);
            }
            switch (status) {
                case 0: {
                    return socket;
                }
                case 1: {
                    throw new IOException("SOCKS: General SOCKS server failure");
                }
                case 2: {
                    throw new IOException("SOCKS: Connection not allowed by ruleset");
                }
                case 3: {
                    throw new IOException("SOCKS: Network unreachable");
                }
                case 4: {
                    throw new IOException("SOCKS: Host unreachable");
                }
                case 5: {
                    throw new IOException("SOCKS: Connection refused");
                }
                case 6: {
                    throw new IOException("SOCKS: TTL expired");
                }
                case 7: {
                    throw new IOException("SOCKS: Command not supported");
                }
                case 8: {
                    throw new IOException("SOCKS: Address type not supported");
                }
            }
            throw new IOException("SOCKS: Unknown status response: " + status);
        }
        catch (Exception exp) {
            IOUtil.closeQuietly(is);
            IOUtil.closeQuietly(os);
            IOUtil.closeQuietly(socket);
            if (exp instanceof IOException) {
                throw (IOException)exp;
            }
            throw new IOException("Error: " + exp.getMessage());
        }
    }

    private static void authenticateUserPassword(InputStream is, OutputStream os) throws IOException {
        String userName = ServiceManager.sCfg.mProxyUserName;
        String password = ServiceManager.sCfg.mProxyPassword;
        byte[] buffer = new byte[3 + userName.length() + password.length()];
        int pos = 0;
        buffer[pos++] = 1;
        buffer[pos++] = (byte)userName.length();
        pos = IOUtil.serializeString(userName, buffer, pos);
        buffer[pos++] = (byte)password.length();
        pos = IOUtil.serializeString(password, buffer, pos);
        os.write(buffer, 0, pos);
        if (is.read() == 1 && is.read() == 0) {
            return;
        }
        throw new IOException("Proxy server authentication failed.");
    }
}

