/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import phex.common.QueryRoutingTable;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.msg.MsgManager;
import phex.msg.QueryMsg;
import phex.query.DynamicQueryConstants;

public class DynamicQueryEngine
implements DynamicQueryConstants {
    private MsgManager messageMgr = MsgManager.getInstance();
    private HostManager hostMgr = HostManager.getInstance();
    private NetworkHostsContainer hostsContainer = this.hostMgr.getNetworkHostsContainer();
    private boolean isDynamicQueryStarted;
    private boolean isDynamicQueryStopped;
    private boolean areLeavesQueried;
    private boolean isProbeQuerySent;
    private long queryTimeout;
    private long queryStartTime;
    private long nextProcessTime;
    private int timeToWaitPerHop;
    private int desiredResults;
    private int receivedResults;
    private int estimatedQueriedHorizon;
    private List queriedHosts;
    private QueryMsg query;

    public DynamicQueryEngine(QueryMsg query, int desiredResults) {
        this.query = query;
        this.desiredResults = desiredResults;
        this.isDynamicQueryStarted = false;
        this.isDynamicQueryStopped = false;
        this.areLeavesQueried = false;
        this.isProbeQuerySent = false;
        this.queryTimeout = 300000L;
        this.timeToWaitPerHop = 2400;
        this.estimatedQueriedHorizon = 1;
        this.receivedResults = 0;
        this.queriedHosts = new ArrayList();
        if (query.hasQueryURNs()) {
            desiredResults = 20;
        }
    }

    public void incrementResultCount(int inc) {
        this.receivedResults += inc;
    }

    public int getResultCount() {
        return this.receivedResults;
    }

    public void stopQuery() {
        this.isDynamicQueryStopped = true;
    }

    public boolean areEnoughResultsRouted() {
        return this.receivedResults >= this.desiredResults;
    }

    public Host getFromHost() {
        return this.query.getHeader().getFromHost();
    }

    public boolean isQueryFinished() {
        if (!this.isDynamicQueryStarted) {
            return false;
        }
        if (this.isDynamicQueryStopped) {
            return true;
        }
        if (this.receivedResults >= this.desiredResults) {
            return true;
        }
        if (this.estimatedQueriedHorizon > 250000) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        return currentTime > this.queryStartTime + this.queryTimeout;
    }

    public int getProgress() {
        if (!this.isDynamicQueryStarted) {
            return 0;
        }
        if (this.isDynamicQueryStopped) {
            return 100;
        }
        int resultProgress = (int)((double)this.receivedResults / (double)this.desiredResults * 100.0);
        int horizonProgress = (int)((double)this.estimatedQueriedHorizon / 250000.0 * 100.0);
        long currentTime = System.currentTimeMillis();
        int timeProgress = (int)(100.0 - (double)(this.queryStartTime + this.queryTimeout - currentTime) / (double)this.queryTimeout * 100.0);
        return Math.min(Math.max(resultProgress, Math.max(horizonProgress, timeProgress)), 100);
    }

    public void processQuery() {
        long currentTime = System.currentTimeMillis();
        if (currentTime < this.nextProcessTime) {
            return;
        }
        if (!this.isDynamicQueryStarted) {
            this.isDynamicQueryStarted = true;
            this.queryStartTime = currentTime;
            boolean sentToLeaves = this.processQueryToLeaves();
            if (sentToLeaves) {
                this.nextProcessTime = System.currentTimeMillis() + (long)this.timeToWaitPerHop;
                return;
            }
        }
        if (!this.isProbeQuerySent) {
            this.processProbeQuery();
        } else {
            this.processStandardQuery();
        }
    }

    private void processStandardQuery() {
        QueryRoutingTable qrt;
        int degree;
        Host[] ultrapeers = this.hostsContainer.getUltrapeerConnections();
        int notQueriedHosts = 0;
        Host hostToQuery = null;
        for (int i = 0; i < ultrapeers.length; ++i) {
            if (!ultrapeers[i].isConnectionStable() || this.queriedHosts.contains(ultrapeers[i])) continue;
            ++notQueriedHosts;
            hostToQuery = ultrapeers[i];
        }
        if (notQueriedHosts == 0 || hostToQuery == null) {
            this.nextProcessTime = System.currentTimeMillis() + 5000L;
            return;
        }
        byte maxTTL = hostToQuery.getMaxTTL();
        byte ttl = this.calculateTTL(maxTTL, degree = hostToQuery.getUltrapeerDegree(), notQueriedHosts);
        if (ttl == 1 && hostToQuery.isUPQueryRoutingSupported() && ((qrt = hostToQuery.getLastReceivedRoutingTable()) == null || !qrt.containsQuery(this.query))) {
            ttl = 2;
        }
        QueryMsg newQuery = new QueryMsg(this.query, ttl);
        hostToQuery.queueMessageToSend(newQuery);
        this.queriedHosts.add(hostToQuery);
        this.estimatedQueriedHorizon = this.calculateEstimatedHorizon(degree, ttl);
        this.nextProcessTime = System.currentTimeMillis() + (long)(ttl * this.timeToWaitPerHop);
        this.adjustTimeToWaitPerHop();
    }

    private void processProbeQuery() {
        Host[] ultrapeers = this.hostsContainer.getUltrapeerConnections();
        ArrayList<Host> directHitList = new ArrayList<Host>(ultrapeers.length);
        ArrayList<Host> failedList = new ArrayList<Host>(ultrapeers.length);
        for (int i = 0; i < ultrapeers.length; ++i) {
            QueryRoutingTable qrt = ultrapeers[i].getLastReceivedRoutingTable();
            if (ultrapeers[i].isUPQueryRoutingSupported() && qrt != null) {
                if (qrt.containsQuery(this.query)) {
                    directHitList.add(ultrapeers[i]);
                    continue;
                }
                failedList.add(ultrapeers[i]);
                continue;
            }
            failedList.add(0, ultrapeers[i]);
        }
        int directProbeSize = directHitList.size();
        int failedProbeSize = 0;
        int toIdx = Math.min(10, directProbeSize);
        this.sendProbeQueryToHosts(directHitList.subList(0, toIdx), (byte)1);
        directProbeSize = toIdx;
        if (directProbeSize < 4) {
            toIdx = Math.min(3, failedList.size());
            this.sendProbeQueryToHosts(failedList.subList(0, toIdx), (byte)2);
            failedProbeSize = toIdx;
        }
        this.nextProcessTime = System.currentTimeMillis() + (long)(this.timeToWaitPerHop * (directProbeSize + failedProbeSize));
        this.isProbeQuerySent = true;
    }

    private boolean processQueryToLeaves() {
        QueryRoutingTable qrt = this.messageMgr.getLastSentQueryRoutingTable();
        if (qrt != null && qrt.containsQuery(this.query)) {
            QueryMsg newQuery = new QueryMsg(this.query, 1);
            this.estimatedQueriedHorizon += this.hostsContainer.getLeafConnectionCount();
            this.messageMgr.forwardQueryToLeaves(newQuery, newQuery.getHeader().getFromHost());
            return true;
        }
        return false;
    }

    public void sendProbeQueryToHosts(List hostList, byte ttl) {
        Iterator iterator = hostList.iterator();
        QueryMsg newQuery = new QueryMsg(this.query, 1);
        while (iterator.hasNext()) {
            Host host = (Host)iterator.next();
            host.queueMessageToSend(newQuery);
            this.queriedHosts.add(host);
            int degree = host.getUltrapeerDegree();
            this.estimatedQueriedHorizon = this.calculateEstimatedHorizon(degree, ttl);
        }
    }

    private int calculateEstimatedHorizon(int degree, byte ttl) {
        int hostCount = 0;
        while (ttl > 0) {
            hostCount = (int)((double)hostCount + Math.pow(degree - 1, ttl - 1));
            ttl = (byte)(ttl - 1);
        }
        return hostCount;
    }

    private byte calculateTTL(byte maxTTL, int degree, int connectionCount) {
        double resultsPerHost = (double)this.receivedResults / (double)this.estimatedQueriedHorizon;
        int missingResults = this.desiredResults - this.receivedResults;
        int hostsNeededToQuery = resultsPerHost == 0.0 ? 50000 : (int)((double)missingResults / resultsPerHost);
        int hostsPerConnection = hostsNeededToQuery / connectionCount;
        for (byte i = 1; i < 6; i = (byte)(i + 1)) {
            if (i > maxTTL) {
                return maxTTL;
            }
            int hosts = (int)(16.0 * (double)this.calculateEstimatedHorizon(degree, i));
            if (hosts < hostsPerConnection) continue;
            return i;
        }
        return maxTTL;
    }

    private void adjustTimeToWaitPerHop() {
        if (this.timeToWaitPerHop > 100 && System.currentTimeMillis() - this.queryStartTime > 6000L) {
            double ratio = this.receivedResults == 0 ? 20.0 : (double)Math.max(20, this.desiredResults / 2 / this.receivedResults);
            this.timeToWaitPerHop -= (int)(200.0 * ratio);
            if (this.timeToWaitPerHop < 100) {
                this.timeToWaitPerHop = 100;
            }
        }
    }
}

