/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import phex.common.ThreadTracking;
import phex.host.Host;
import phex.query.DynamicQueryEngine;
import phex.utils.NLogger;

public class DynamicQueryWorker
implements Runnable {
    private static final int WORKER_SLEEP_TIME = 500;
    private List queryList = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDynamicQueryEngine(DynamicQueryEngine engine) {
        List list = this.queryList;
        synchronized (list) {
            this.queryList.add(engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDynamicQuerysForHost(Host host) {
        ArrayList<DynamicQueryEngine> removeList = new ArrayList<DynamicQueryEngine>();
        List list = this.queryList;
        synchronized (list) {
            Iterator iterator = this.queryList.iterator();
            while (iterator.hasNext()) {
                DynamicQueryEngine queryEngine = (DynamicQueryEngine)iterator.next();
                if (queryEngine.getFromHost() != host) continue;
                removeList.add(queryEngine);
            }
            this.queryList.removeAll(removeList);
        }
    }

    public void startQueryWorker() {
        Thread thread = new Thread(ThreadTracking.rootThreadGroup, this, "DynamicQueryWorker-" + Integer.toHexString(this.hashCode()));
        thread.setPriority(5);
        thread.setDaemon(true);
        thread.start();
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException exp) {
                Thread.currentThread().interrupt();
            }
            try {
                this.processQueryList();
                continue;
            }
            catch (Throwable th) {
                NLogger.error("Query.DynamicQueryWorker", (Object)th, th);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueryList() {
        DynamicQueryEngine[] queryEngines;
        List list = this.queryList;
        synchronized (list) {
            int size = this.queryList.size();
            if (size == 0) {
                return;
            }
            queryEngines = new DynamicQueryEngine[size];
            this.queryList.toArray(queryEngines);
        }
        for (int i = 0; i < queryEngines.length; ++i) {
            if (queryEngines[i].isQueryFinished()) {
                List list2 = this.queryList;
                synchronized (list2) {
                    this.queryList.remove(queryEngines[i]);
                    continue;
                }
            }
            queryEngines[i].processQuery();
        }
    }
}

