/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import java.util.StringTokenizer;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.connection.NetworkManager;
import phex.download.RemoteFile;
import phex.msg.GUID;
import phex.msg.QueryMsg;
import phex.msg.QueryResponseMsg;
import phex.msg.QueryResponseRecord;
import phex.query.QueryHitHost;
import phex.query.Search;
import phex.utils.SearchEngine;

public class KeywordSearch
extends Search {
    private String searchString;
    private URN searchURN;

    public KeywordSearch(String aSearchString) {
        this(aSearchString, null);
    }

    public KeywordSearch(String aSearchString, URN aSearchURN) {
        this.searchString = aSearchString;
        this.searchURN = aSearchURN;
        boolean isPhexBehindFirewall = !NetworkManager.getInstance().hasConnectedIncoming();
        this.queryMsg = new QueryMsg((byte)ServiceManager.sCfg.ttl, this.searchString, this.searchURN, false, isPhexBehindFirewall);
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String aSearchString) {
        this.searchString = aSearchString;
        this.searchURN = null;
        boolean isPhexBehindFirewall = !NetworkManager.getInstance().hasConnectedIncoming();
        this.queryMsg = new QueryMsg((byte)ServiceManager.sCfg.ttl, this.searchString, this.searchURN, false, isPhexBehindFirewall);
        this.fireSearchChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResponse(QueryResponseMsg msg) {
        if (!msg.getHeader().getMsgID().equals(this.queryMsg.getHeader().getMsgID())) {
            return;
        }
        long speed = msg.getRemoteHostSpeed();
        GUID rcID = msg.getRemoteClientID();
        DestAddress address = msg.getDestAddress();
        QueryHitHost qhHost = new QueryHitHost(rcID, address, speed);
        qhHost.setQHDFlags(msg.getPushNeededFlag(), msg.getServerBusyFlag(), msg.getHasUploadedFlag(), msg.getUploadSpeedFlag());
        qhHost.setQueryResponseFields(msg);
        int recordCount = msg.getRecordCount();
        ArrayList<RemoteFile> newHitList = new ArrayList<RemoteFile>(recordCount);
        for (int i = 0; i < recordCount; ++i) {
            QueryResponseRecord rec = msg.getMsgRecord(i);
            if (this.searchURN != null && rec.getURN() != null && !this.searchURN.equals(rec.getURN())) continue;
            KeywordSearch keywordSearch = this;
            synchronized (keywordSearch) {
                RemoteFile rfile;
                long fileSize = rec.getFileSize();
                String filename = rec.getFilename();
                URN urn = rec.getURN();
                int fileIndex = rec.getFileIndex();
                String metaData = rec.getMetaData();
                short score = this.searchString == null ? (short)100 : (short)KeywordSearch.calculateSearchScore(this.searchString, filename);
                RemoteFile availableHit = this.searchResultHolder.findQueryHit(qhHost, urn, filename, fileSize, fileIndex);
                if (availableHit != null) {
                    availableHit.updateQueryHitHost(qhHost);
                    availableHit.setMetaData(metaData);
                } else {
                    String pathInfo = rec.getPathInfo();
                    rfile = new RemoteFile(qhHost, fileIndex, filename, pathInfo, fileSize, urn, metaData, score);
                    this.searchResultHolder.addQueryHit(rfile);
                    newHitList.add(rfile);
                }
                DestAddress[] alternateLocations = rec.getAlternateLocations();
                if (urn != null && alternateLocations != null) {
                    for (int j = 0; j < alternateLocations.length; ++j) {
                        QueryHitHost qhh = new QueryHitHost(null, alternateLocations[j], -1L);
                        availableHit = this.searchResultHolder.findQueryHit(qhHost, urn, filename, fileSize, fileIndex);
                        if (availableHit != null) {
                            availableHit.updateQueryHitHost(qhHost);
                            availableHit.setMetaData(metaData);
                            continue;
                        }
                        rfile = new RemoteFile(qhh, -1, filename, "", fileSize, urn, metaData, score);
                        this.searchResultHolder.addQueryHit(rfile);
                        newHitList.add(rfile);
                    }
                }
                continue;
            }
        }
        if (newHitList.size() > 0) {
            if (this.queryEngine != null) {
                this.queryEngine.incrementResultCount(newHitList.size());
            }
            RemoteFile[] newHits = new RemoteFile[newHitList.size()];
            newHitList.toArray(newHits);
            this.fireSearchHitsAdded(newHits);
        }
    }

    public static short calculateSearchScore(String searchStr, String resultStr) {
        double tokenCount = 0.0;
        double hitCount = 0.0;
        StringTokenizer tokens = new StringTokenizer(searchStr);
        SearchEngine searchEngine = new SearchEngine();
        searchEngine.setText(resultStr, false);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            tokenCount += 1.0;
            searchEngine.setPattern(token, false);
            if (!searchEngine.match()) continue;
            hitCount += 1.0;
        }
        double perc = hitCount / tokenCount * 100.0;
        return (short)perc;
    }

    public String toString() {
        return "[KeywordSearch:" + this.searchString + "," + super.toString() + "]";
    }
}

