/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import phex.common.Cfg;
import phex.common.ServiceManager;
import phex.event.QueryHistoryChangeListener;
import phex.msg.QueryMsg;
import phex.utils.CircularQueue;
import phex.utils.NLogger;

public class QueryHistoryMonitor {
    private Cfg configuration = ServiceManager.sCfg;
    private CircularQueue historyQueue;
    private BufferedWriter fileWriter;
    private QueryHistoryChangeListener changeListener;

    public QueryHistoryMonitor() {
        this.historyQueue = new CircularQueue(this.configuration.searchHistoryLength, this.configuration.searchHistoryLength);
        this.updateFileMonitoring();
    }

    public void shutdown() {
        if (this.fileWriter != null) {
            try {
                this.fileWriter.close();
                NLogger.debug(QueryHistoryMonitor.class, (Object)"End QueryMonitoring to file.");
            }
            catch (IOException exp) {
                NLogger.error(QueryHistoryMonitor.class, (Object)exp, (Throwable)exp);
            }
            this.fileWriter = null;
        }
    }

    private void updateFileMonitoring() {
        if (this.configuration.monitorSearchHistory && this.configuration.searchMonitorFile.length() > 0) {
            try {
                File file = new File(this.configuration.searchMonitorFile);
                File parent = file.getParentFile();
                if (parent != null) {
                    parent.mkdirs();
                }
                file.createNewFile();
                this.fileWriter = new BufferedWriter(new FileWriter(file.getAbsolutePath(), true));
                NLogger.debug(QueryHistoryMonitor.class, (Object)("Start QueryMonitoring to " + file.getAbsolutePath()));
            }
            catch (IOException exp) {
                NLogger.error(QueryHistoryMonitor.class, (Object)exp, (Throwable)exp);
            }
        } else {
            this.shutdown();
        }
    }

    public void setHistoryMonitored(boolean state) {
        this.configuration.monitorSearchHistory = state;
        this.updateFileMonitoring();
        this.configuration.save();
    }

    public boolean isHistoryMonitored() {
        return this.configuration.monitorSearchHistory;
    }

    public synchronized void setMaxHistroySize(int size) {
        if (size == this.historyQueue.getCapacity()) {
            return;
        }
        this.historyQueue = new CircularQueue(size, size);
        this.configuration.searchHistoryLength = size;
        this.configuration.save();
    }

    public synchronized int getMaxHistorySize() {
        return this.historyQueue.getCapacity();
    }

    public synchronized int getHistorySize() {
        return this.historyQueue.getSize();
    }

    public synchronized QueryMsg getSearchQueryAt(int index) {
        return (QueryMsg)this.historyQueue.get(index);
    }

    public synchronized void addSearchQuery(QueryMsg query) {
        if (this.configuration.monitorSearchHistory) {
            if (query.getSearchString().length() > 0) {
                this.historyQueue.addToHead(query);
                this.fireQueryHistoryChanged();
            }
            if (this.fileWriter != null) {
                try {
                    this.fileWriter.write(query.getSearchString());
                    this.fileWriter.newLine();
                }
                catch (IOException exp) {
                    NLogger.warn(QueryHistoryMonitor.class, (Object)exp, (Throwable)exp);
                }
            }
        }
    }

    public void setQueryHistoryChangeListener(QueryHistoryChangeListener listener) {
        if (this.changeListener != null) {
            throw new RuntimeException("CaughtHostChangedListener already used!!");
        }
        this.changeListener = listener;
    }

    private void fireQueryHistoryChanged() {
        this.changeListener.queryHistoryChanged();
    }
}

