/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import phex.common.address.DestAddress;
import phex.connection.NetworkManager;
import phex.msg.GUID;
import phex.msg.QueryResponseMsg;
import phex.query.QueryConstants;
import phex.utils.VendorCodes;

public class QueryHitHost
implements QueryConstants {
    private GUID hostGUID;
    private Long hostSpeedObj;
    private short pushNeededFlag;
    private short serverBusyFlag;
    private short hasUploadedFlag;
    private short uploadSpeedFlag;
    private String vendor;
    private boolean isChatSupported;
    private boolean isThexSupported;
    private boolean isBrowseHostSupported;
    private Short hostRating;
    private DestAddress hostAddress;
    private DestAddress[] pushProxyAddresses;

    public QueryHitHost(GUID aHostGUID, DestAddress address, long aHostSpeed) {
        this.hostGUID = aHostGUID;
        this.hostAddress = address;
        this.hostSpeedObj = new Long(aHostSpeed);
        this.setQHDFlags((short)-1, (short)-1, (short)-1, (short)-1);
        this.hostRating = new Short(-1);
    }

    public void setQueryResponseFields(QueryResponseMsg msg) {
        this.setVendorCode(msg.getVendorCode());
        this.setChatSupported(msg.isChatSupported());
        this.setBrowseHostSupported(msg.isBrowseHostSupported());
        this.setPushProxyAddresses(msg.getPushProxyAddresses());
    }

    public DestAddress[] getPushProxyAddresses() {
        return this.pushProxyAddresses;
    }

    public void setPushProxyAddresses(DestAddress[] pushProxyAddresses) {
        this.pushProxyAddresses = pushProxyAddresses;
    }

    public void setVendorCode(String aVendorCode) {
        if (aVendorCode != null) {
            this.vendor = VendorCodes.getVendorName(aVendorCode);
        }
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setChatSupported(boolean state) {
        this.isChatSupported = state;
    }

    public boolean isChatSupported() {
        return this.isChatSupported;
    }

    public void setThexSupported(boolean state) {
        this.isThexSupported = state;
    }

    public boolean isThexSupported() {
        return this.isThexSupported;
    }

    public void setBrowseHostSupported(boolean state) {
        this.isBrowseHostSupported = state;
    }

    public boolean isBrowseHostSupported() {
        return this.isBrowseHostSupported;
    }

    public GUID getHostGUID() {
        return this.hostGUID;
    }

    public void setHostGUID(GUID guid) {
        this.hostGUID = guid;
    }

    public int getHostSpeed() {
        return this.hostSpeedObj.intValue();
    }

    public void setHostSpeed(long speed) {
        this.hostSpeedObj = new Long(speed);
        this.calculateHostRating();
    }

    public Long getHostSpeedObject() {
        return this.hostSpeedObj;
    }

    public DestAddress getHostAddress() {
        return this.hostAddress;
    }

    public void setQHDFlags(short aPushNeededFlag, short aServerBusyFlag, short aHasUploadedFlag, short aUploadSpeedFlag) {
        this.pushNeededFlag = aPushNeededFlag;
        this.serverBusyFlag = aServerBusyFlag;
        this.hasUploadedFlag = aHasUploadedFlag;
        this.uploadSpeedFlag = aUploadSpeedFlag;
    }

    public boolean isPushNeeded() {
        return this.pushNeededFlag == 1;
    }

    public short getHostRating() {
        if (this.hostRating == -1) {
            this.calculateHostRating();
        }
        return this.hostRating;
    }

    public Short getHostRatingObject() {
        if (this.hostRating == -1) {
            this.calculateHostRating();
        }
        return this.hostRating;
    }

    private void calculateHostRating() {
        NetworkManager networkMgr = NetworkManager.getInstance();
        if (this.pushNeededFlag == 1 && !networkMgr.hasConnectedIncoming()) {
            this.hostRating = new Short(0);
            return;
        }
        if (this.serverBusyFlag == 1) {
            this.hostRating = new Short(1);
            return;
        }
        short tmpHostRating = this.pushNeededFlag == 1 ? (this.serverBusyFlag == 0 ? (short)3 : 2) : (this.pushNeededFlag == 0 ? (this.serverBusyFlag == 0 ? (short)6 : 5) : (!networkMgr.hasConnectedIncoming() ? (short)3 : 4));
        if (this.hasUploadedFlag == 1) {
            tmpHostRating = (short)(tmpHostRating + 2);
        } else if (this.hasUploadedFlag == -1) {
            tmpHostRating = (short)(tmpHostRating + 1);
        }
        this.hostRating = new Short(tmpHostRating);
    }
}

