/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import phex.common.IntObj;
import phex.download.RemoteFile;
import phex.event.AsynchronousDispatcher;
import phex.event.SearchDataEvent;
import phex.event.SearchDataListener;
import phex.query.Search;
import phex.query.SearchResultHolder;
import phex.rules.Rule;

public class RuleFilteredSearch
implements SearchDataListener {
    private Search search;
    private SearchResultHolder displayedSearchResults;
    private SearchResultHolder hiddenSearchResults;
    private Rule[] searchFilterRules;
    private ArrayList listenerList = new ArrayList(2);

    public RuleFilteredSearch(Search search, Rule ruleFilter) {
        this(search, new Rule[]{ruleFilter});
    }

    public RuleFilteredSearch(Search search, Rule[] ruleFilters) {
        this.displayedSearchResults = new SearchResultHolder();
        this.hiddenSearchResults = new SearchResultHolder();
        this.search = search;
        this.searchFilterRules = ruleFilters;
        search.addSearchChangeListener(this);
    }

    public int getResultCount() {
        return this.displayedSearchResults.getQueryHitCount();
    }

    public int getHiddenCount() {
        return this.hiddenSearchResults.getQueryHitCount();
    }

    public int getProgress() {
        return this.search.getProgress();
    }

    public IntObj getProgressObj() {
        return this.search.getProgressObj();
    }

    public boolean isSearching() {
        return this.search.isSearching();
    }

    public void checkForSearchTimeout(long currentTime) {
        this.search.checkForSearchTimeout(currentTime);
    }

    public void startSearching() {
        this.search.startSearching();
    }

    public void stopSearching() {
        this.search.stopSearching();
    }

    private void processRules(RemoteFile[] remoteFiles) {
        for (int i = 0; i < this.searchFilterRules.length; ++i) {
            this.searchFilterRules[i].process(this.search, remoteFiles);
        }
        ArrayList<RemoteFile> newHitList = new ArrayList<RemoteFile>(remoteFiles.length);
        for (int j = 0; j < remoteFiles.length; ++j) {
            if (remoteFiles[j].isFilteredRemoved()) continue;
            if (remoteFiles[j].isFilteredHidden()) {
                this.hiddenSearchResults.addQueryHit(remoteFiles[j]);
                continue;
            }
            this.displayedSearchResults.addQueryHit(remoteFiles[j]);
            newHitList.add(remoteFiles[j]);
        }
        if (newHitList.size() > 0) {
            RemoteFile[] newHits = new RemoteFile[newHitList.size()];
            newHitList.toArray(newHits);
            this.fireSearchHitsAdded(newHits);
        }
    }

    public void searchDataChanged(SearchDataEvent event) {
        short type = event.getType();
        switch (type) {
            case 1: {
                this.processRules(event.getSearchData());
                break;
            }
            default: {
                this.fireSearchChangeEvent(event);
            }
        }
    }

    public void addSearchDataListener(SearchDataListener listener) {
        this.listenerList.add(listener);
    }

    public void removeSearchDataListener(SearchDataListener listener) {
        this.listenerList.remove(listener);
    }

    protected void fireSearchStarted() {
        SearchDataEvent searchChangeEvent = new SearchDataEvent(this, 0);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    protected void fireSearchStoped() {
        SearchDataEvent searchChangeEvent = new SearchDataEvent(this, 4);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    protected void fireSearchFiltered() {
        SearchDataEvent searchChangeEvent = new SearchDataEvent(this, 2);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    public void fireSearchChanged() {
        SearchDataEvent searchChangeEvent = new SearchDataEvent(this, 3);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    protected void fireSearchHitsAdded(RemoteFile[] newHits) {
        SearchDataEvent searchChangeEvent = new SearchDataEvent(this, 1, newHits);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    private void fireSearchChangeEvent(final SearchDataEvent searchChangeEvent) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = RuleFilteredSearch.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    if (!(listeners[i] instanceof SearchDataListener)) continue;
                    SearchDataListener listener = (SearchDataListener)listeners[i];
                    listener.searchDataChanged(searchChangeEvent);
                }
            }
        });
    }
}

