/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import java.util.Iterator;
import phex.common.ServiceManager;
import phex.common.address.DestAddress;
import phex.event.AsynchronousDispatcher;
import phex.event.SearchDataEvent;
import phex.event.SearchDataListener;
import phex.event.SearchListChangeListener;
import phex.msg.GUID;
import phex.msg.QueryResponseMsg;
import phex.query.BrowseHostResults;
import phex.query.KeywordSearch;
import phex.query.Search;
import phex.query.WhatsNewSearch;

public class SearchContainer {
    private ArrayList listenerList = new ArrayList(2);
    protected ArrayList searchList;
    private SearchDataListener searchChangeListener = new SingleSearchChangeListener();

    public SearchContainer() {
        this.searchList = new ArrayList();
    }

    public synchronized Search createSearch(String queryStr) {
        KeywordSearch search = new KeywordSearch(queryStr);
        this.insertToSearchList(search, 0);
        if (this.searchList.size() > ServiceManager.sCfg.mSearchMaxConcurrent) {
            int idx = this.searchList.size() - 1;
            this.removeFromSearchList(idx);
        }
        search.startSearching();
        return search;
    }

    public synchronized Search createWhatsNewSearch() {
        WhatsNewSearch search = new WhatsNewSearch();
        this.insertToSearchList(search, 0);
        if (this.searchList.size() > ServiceManager.sCfg.mSearchMaxConcurrent) {
            int idx = this.searchList.size() - 1;
            this.removeFromSearchList(idx);
        }
        search.startSearching();
        return search;
    }

    public synchronized BrowseHostResults createBrowseHostSearch(DestAddress hostAddress, GUID hostGUID) {
        BrowseHostResults search = new BrowseHostResults(hostAddress, hostGUID);
        this.insertToSearchList(search, 0);
        if (this.searchList.size() > ServiceManager.sCfg.mSearchMaxConcurrent) {
            int idx = this.searchList.size() - 1;
            this.removeFromSearchList(idx);
        }
        search.startSearching();
        return search;
    }

    protected synchronized void insertToSearchList(Search search, int position) {
        search.addSearchChangeListener(this.searchChangeListener);
        this.searchList.add(position, search);
        this.fireSearchAdded(search, position);
    }

    protected synchronized void removeFromSearchList(int index) {
        Search search = this.getSearchAt(index);
        search.stopSearching();
        search.removeSearchChangeListener(this.searchChangeListener);
        this.searchList.remove(index);
        this.fireSearchRemoved(search, index);
    }

    public synchronized Search getRunningKeywordSearch(String searchString) {
        Iterator iterator = this.searchList.iterator();
        while (iterator.hasNext()) {
            Search search = (Search)iterator.next();
            if (!search.isSearching() || !(search instanceof KeywordSearch) || !((KeywordSearch)search).getSearchString().equals(searchString)) continue;
            return search;
        }
        return null;
    }

    public synchronized Search getRunningBrowseHost(DestAddress hostAddress, GUID hostId) {
        Iterator iterator = this.searchList.iterator();
        while (iterator.hasNext()) {
            BrowseHostResults browseHost;
            Search search = (Search)iterator.next();
            if (!search.isSearching() || !(search instanceof BrowseHostResults) || !(browseHost = (BrowseHostResults)search).getDestAddress().equals(hostAddress) && !browseHost.getHostGUID().equals(hostId)) continue;
            return search;
        }
        return null;
    }

    public synchronized int getSearchCount() {
        return this.searchList.size();
    }

    public synchronized int getIndexOfSearch(Search search) {
        int size = this.searchList.size();
        for (int i = 0; i < size; ++i) {
            if (search != this.searchList.get(i)) continue;
            return i;
        }
        return -1;
    }

    public synchronized Search getSearchAt(int index) {
        if (index < 0 || index >= this.getSearchCount()) {
            return null;
        }
        return (Search)this.searchList.get(index);
    }

    public synchronized void removeSearch(Search search) {
        int index = this.searchList.indexOf(search);
        if (index >= 0) {
            this.removeFromSearchList(index);
        }
    }

    public synchronized void removeSearch(int index) {
        this.removeFromSearchList(index);
    }

    public synchronized void stopExpiredSearches(long currentTime) {
        for (int i = 0; i < this.searchList.size(); ++i) {
            ((Search)this.searchList.get(i)).checkForSearchTimeout(currentTime);
        }
    }

    public synchronized void stopAllSearches() {
        for (int i = 0; i < this.searchList.size(); ++i) {
            ((Search)this.searchList.get(i)).stopSearching();
        }
    }

    public synchronized void removeAllSearches() {
        for (int i = this.searchList.size() - 1; i >= 0; --i) {
            this.removeFromSearchList(i);
        }
    }

    public synchronized void processQueryResponse(QueryResponseMsg msg) {
        for (int i = 0; i < this.searchList.size(); ++i) {
            Search search = (Search)this.searchList.get(i);
            if (search instanceof BrowseHostResults) continue;
            search.processResponse(msg);
        }
    }

    public void addSearchListChangeListener(SearchListChangeListener listener) {
        this.listenerList.add(listener);
    }

    public void removeSearchListChangeListener(SearchListChangeListener listener) {
        this.listenerList.remove(listener);
    }

    protected void fireSearchChanged(final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = SearchContainer.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    SearchListChangeListener listener = (SearchListChangeListener)listeners[i];
                    listener.searchChanged(position);
                }
            }
        });
    }

    protected void fireSearchAdded(final Search search, final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = SearchContainer.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    SearchListChangeListener listener = (SearchListChangeListener)listeners[i];
                    listener.searchAdded(search, position);
                }
            }
        });
    }

    protected void fireSearchRemoved(final Search search, final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = SearchContainer.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    SearchListChangeListener listener = (SearchListChangeListener)listeners[i];
                    listener.searchRemoved(search, position);
                }
            }
        });
    }

    protected void setSearchChangeListener(SearchDataListener listener) {
        this.searchChangeListener = listener;
    }

    protected void fireSearchChanged(Search search) {
        int position = this.searchList.indexOf(search);
        if (position >= 0) {
            this.fireSearchChanged(position);
        }
    }

    private class SingleSearchChangeListener
    implements SearchDataListener {
        private SingleSearchChangeListener() {
        }

        public void searchDataChanged(SearchDataEvent event) {
            Search source = (Search)event.getSource();
            SearchContainer.this.fireSearchChanged(source);
        }
    }
}

