/*
 * Decompiled with CFR 0.152.
 */
package phex.rules;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import phex.common.Environment;
import phex.common.ThreadPool;
import phex.common.file.FileManager;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.connection.NetworkManager;
import phex.rules.DefaultSearchFilterRules;
import phex.rules.Rule;
import phex.rules.condition.AndConcatCondition;
import phex.rules.condition.Condition;
import phex.rules.consequence.Consequence;
import phex.utils.NLogger;
import phex.utils.VersionUtils;
import phex.xml.sax.DElement;
import phex.xml.sax.DPhex;
import phex.xml.sax.DSubElementList;
import phex.xml.sax.XMLBuilder;
import phex.xml.sax.rules.DAndConcatCondition;
import phex.xml.sax.rules.DCondition;
import phex.xml.sax.rules.DConsequence;
import phex.xml.sax.rules.DConsequencesList;
import phex.xml.sax.rules.DSearchRule;

public class SearchFilterRules {
    private boolean hasChangedSinceLastSave;
    private List searchFilterRules = new ArrayList();

    public SearchFilterRules() {
        this.searchFilterRules.add(DefaultSearchFilterRules.ADULT_FILTER_RULE);
        this.searchFilterRules.add(DefaultSearchFilterRules.SCAM_FILE_FILTER_RULE);
        this.hasChangedSinceLastSave = false;
        Environment.getInstance().scheduleTimerTask(new SaveFavoritesTimer(), 60000L, 60000L);
    }

    public synchronized void setRuleList(List newList) {
        this.searchFilterRules = newList;
        this.hasChangedSinceLastSave = true;
    }

    public synchronized List getAsList() {
        return Collections.unmodifiableList(this.searchFilterRules);
    }

    public synchronized List getPermanentList() {
        ArrayList<Rule> list = new ArrayList<Rule>();
        Iterator iterator = this.searchFilterRules.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            if (!rule.isPermanentlyEnabled()) continue;
            list.add(rule);
        }
        return list;
    }

    public synchronized int getCount() {
        return this.searchFilterRules.size();
    }

    public synchronized Rule getRuleAt(int index) {
        if (index < 0 || index >= this.searchFilterRules.size()) {
            return null;
        }
        return (Rule)this.searchFilterRules.get(index);
    }

    public synchronized Rule getRuleById(String id) {
        Iterator iterator = this.searchFilterRules.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            if (!id.equals(rule.getId())) continue;
            return rule;
        }
        return null;
    }

    public synchronized void save() {
        if (!this.hasChangedSinceLastSave) {
            return;
        }
        NLogger.debug(SearchFilterRules.class, (Object)"Saving search filters.");
        try {
            DPhex dPhex = new DPhex();
            dPhex.setPhexVersion(VersionUtils.getFullProgramVersion());
            DSubElementList dList = new DSubElementList("search-rule-list");
            dPhex.setSearchRuleList(dList);
            List searchRuleList = dList.getSubElementList();
            Iterator iterator = this.searchFilterRules.iterator();
            while (iterator.hasNext()) {
                Rule rule = (Rule)iterator.next();
                DSearchRule dRule = new DSearchRule();
                dRule.setId(rule.getId());
                dRule.setName(rule.getName());
                dRule.setDescription(rule.getDescription());
                dRule.setPermanentlyEnabled(rule.isPermanentlyEnabled());
                DAndConcatCondition andCondition = new DAndConcatCondition();
                List dCondList = andCondition.getSubElementList();
                Iterator condIterator = rule.getConditions().iterator();
                while (condIterator.hasNext()) {
                    Condition cond = (Condition)condIterator.next();
                    DCondition dCond = cond.createDCondition();
                    dCondList.add(dCond);
                }
                dRule.setAndConcatCondition(andCondition);
                DConsequencesList dConsequ = new DConsequencesList();
                List dConsequList = dConsequ.getSubElementList();
                Iterator consequIterator = rule.getConsequences().iterator();
                while (consequIterator.hasNext()) {
                    Consequence consqu = (Consequence)consequIterator.next();
                    DElement dCond = consqu.createDConsequence();
                    dConsequList.add(dCond);
                }
                dRule.setConsequencesList(dConsequ);
                searchRuleList.add(dRule);
            }
            NetworkManager networkMgr = NetworkManager.getInstance();
            File outputFile = networkMgr.getGnutellaNetwork().getSearchFilterFile();
            ManagedFile managedFile = FileManager.getInstance().getReadWriteManagedFile(outputFile);
            XMLBuilder.saveToFile(managedFile, dPhex);
            this.hasChangedSinceLastSave = false;
        }
        catch (IOException exp) {
            NLogger.error("Favorites", (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsSaveFailed", new String[]{exp.toString()});
        }
        catch (ManagedFileException exp) {
            NLogger.error("Favorites", (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsSaveFailed", new String[]{exp.toString()});
        }
    }

    public synchronized void load() {
        NLogger.debug(SearchFilterRules.class, (Object)"Loading search filters.");
        NetworkManager networkMgr = NetworkManager.getInstance();
        File inputFile = networkMgr.getGnutellaNetwork().getSearchFilterFile();
        try {
            if (!inputFile.exists()) {
                return;
            }
            FileManager fileMgr = FileManager.getInstance();
            ManagedFile managedFile = fileMgr.getReadWriteManagedFile(inputFile);
            DPhex dPhex = XMLBuilder.loadDPhexFromFile(managedFile);
            if (dPhex == null) {
                NLogger.debug("Favorites", (Object)"No DPhex found.");
                return;
            }
            DSubElementList dRuleList = dPhex.getSearchRuleList();
            if (dRuleList == null) {
                NLogger.warn("Favorites", (Object)"No DSearchRule list found.");
            }
            ArrayList<Rule> newRules = new ArrayList<Rule>();
            Iterator iterator = dRuleList.getSubElementList().iterator();
            while (iterator.hasNext()) {
                DSearchRule dRule = (DSearchRule)iterator.next();
                Rule rule = null;
                boolean isNew = false;
                String id = dRule.getId();
                if (id != null) {
                    rule = this.getRuleById(id);
                }
                if (rule == null) {
                    isNew = true;
                    rule = new Rule();
                }
                if (!rule.isDefaultRule()) {
                    String name = dRule.getName();
                    rule.setName(name);
                    DAndConcatCondition dCondition = dRule.getAndConcatCondition();
                    AndConcatCondition andCond = (AndConcatCondition)dCondition.createCondition();
                    Iterator conditions = andCond.getConditions().iterator();
                    while (conditions.hasNext()) {
                        rule.addCondition((Condition)conditions.next());
                    }
                    DConsequencesList consequencesList = dRule.getConsequencesList();
                    Iterator consequIterator = consequencesList.getSubElementList().iterator();
                    while (consequIterator.hasNext()) {
                        DConsequence dConsequ = (DConsequence)consequIterator.next();
                        Consequence conseq = dConsequ.createConsequence();
                        rule.addConsequence(conseq);
                    }
                }
                if (dRule.isHasPermanentlyEnabled()) {
                    rule.setPermanentlyEnabled(dRule.isPermanentlyEnabled());
                }
                if (!isNew) continue;
                newRules.add(rule);
            }
            this.searchFilterRules.addAll(newRules);
        }
        catch (IOException exp) {
            NLogger.error("Favorites", (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsLoadFailed", new String[]{exp.toString()});
            return;
        }
        catch (ManagedFileException exp) {
            NLogger.error("Favorites", (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsLoadFailed", new String[]{exp.toString()});
            return;
        }
    }

    private class SaveFavoritesTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 60000L;

        private SaveFavoritesTimer() {
        }

        public void run() {
            try {
                ThreadPool.getInstance().addJob(new SaveRunner(), "SaveSearchFilterRules");
            }
            catch (Throwable th) {
                NLogger.error("Favorites", (Object)th, th);
            }
        }
    }

    private class SaveRunner
    implements Runnable {
        private SaveRunner() {
        }

        public void run() {
            SearchFilterRules.this.save();
        }
    }
}

