/*
 * Decompiled with CFR 0.152.
 */
package phex.security;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import phex.security.IPAccessRule;
import phex.utils.IOUtil;

public class FastIpList {
    private List[] ipLists = new List[256];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IPAccessRule rule) {
        int pos = IOUtil.unsignedByte2int(rule.getHostIP()[0]);
        if (this.ipLists[pos] == null) {
            this.ipLists[pos] = new ArrayList();
        }
        List list = this.ipLists[pos];
        synchronized (list) {
            this.ipLists[pos].add(rule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(IPAccessRule rule) {
        int pos = IOUtil.unsignedByte2int(rule.getHostIP()[0]);
        if (this.ipLists[pos] == null) {
            return;
        }
        List list = this.ipLists[pos];
        synchronized (list) {
            this.ipLists[pos].remove(rule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte controlHostIPAccess(byte[] hostIP) {
        int pos = IOUtil.unsignedByte2int(hostIP[0]);
        if (this.ipLists[pos] == null) {
            return 1;
        }
        List list = this.ipLists[pos];
        synchronized (list) {
            Iterator iterator = this.ipLists[pos].iterator();
            while (iterator.hasNext()) {
                IPAccessRule rule = (IPAccessRule)iterator.next();
                if (rule.isDisabled() || rule.isHostIPAllowed(hostIP)) continue;
                if (rule.isStrongFilter()) {
                    return 3;
                }
                return 2;
            }
        }
        return 1;
    }
}

