/*
 * Decompiled with CFR 0.152.
 */
package phex.security;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import phex.common.AbstractManager;
import phex.common.Environment;
import phex.common.ExpiryDate;
import phex.common.address.AddressUtils;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.common.file.FileManager;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.event.AsynchronousDispatcher;
import phex.event.SecurityRulesChangeListener;
import phex.security.FastIpList;
import phex.security.IPAccessRule;
import phex.security.SecurityRule;
import phex.utils.NLogger;
import phex.utils.StringUtils;
import phex.utils.VersionUtils;
import phex.xml.ObjectFactory;
import phex.xml.PhexElement;
import phex.xml.XJBIPAccessRule;
import phex.xml.XJBPhex;
import phex.xml.XJBSecurity;
import phex.xml.XJBSecurityRule;
import phex.xml.XMLBuilder;

public class PhexSecurityManager
extends AbstractManager {
    public static final byte ACCESS_GRANTED = 1;
    public static final byte ACCESS_DENIED = 2;
    public static final byte ACCESS_STRONGLY_DENIED = 3;
    private ArrayList ipAccessRuleList;
    private FastIpList fastIpList;
    private ArrayList listenerList = new ArrayList();

    public PhexSecurityManager() {
        this.ipAccessRuleList = new ArrayList();
        this.fastIpList = new FastIpList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIPAccessRuleCount() {
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            return this.ipAccessRuleList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPAccessRule getIPAccessRule(int index) {
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            if (index < 0 || index >= this.ipAccessRuleList.size()) {
                return null;
            }
            return (IPAccessRule)this.ipAccessRuleList.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPAccessRule[] getIPAccessRulesAt(int[] indices) {
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            int length = indices.length;
            IPAccessRule[] rules = new IPAccessRule[length];
            int listSize = this.ipAccessRuleList.size();
            for (int i = 0; i < length; ++i) {
                rules[i] = indices[i] < 0 || indices[i] >= listSize ? null : (IPAccessRule)this.ipAccessRuleList.get(indices[i]);
            }
            return rules;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPAccessRule createIPAccessRule(String description, boolean isDenyingRule, byte type, byte[] ip, byte[] compareIP, boolean isDisabled, ExpiryDate expiryDate, boolean isDeletedOnExpiry) {
        int position;
        IPAccessRule rule = new IPAccessRule(description, isDenyingRule, type, ip, compareIP, false, false, isDisabled);
        rule.setExpiryDate(expiryDate);
        rule.setDeleteOnExpiry(isDeletedOnExpiry);
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            position = this.ipAccessRuleList.size();
            this.ipAccessRuleList.add(rule);
            this.fastIpList.add(rule);
        }
        this.fireSecurityRuleAdded(rule, position);
        return rule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecurityRule(SecurityRule rule) {
        int idx;
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            idx = this.ipAccessRuleList.indexOf(rule);
            if (idx != -1) {
                this.ipAccessRuleList.remove(idx);
                this.fastIpList.remove((IPAccessRule)rule);
            }
        }
        this.fireSecurityRuleRemoved(idx);
    }

    public byte controlHostAddressAccess(DestAddress address) {
        IpAddress ipAddress = address.getIpAddress();
        if (ipAddress == null) {
            return 1;
        }
        byte[] hostIP = ipAddress.getHostIP();
        return this.controlHostIPAccess(hostIP);
    }

    public byte controlHostIPAccess(byte[] hostIP) {
        return this.fastIpList.controlHostIPAccess(hostIP);
    }

    private void loadHostileHostList(Map systemRuleMap) {
        try {
            String line;
            BufferedReader br;
            NLogger.debug("Security", (Object)"Load hostile hosts file.");
            long start = System.currentTimeMillis();
            InputStream inStream = ClassLoader.getSystemResourceAsStream("phex/resources/hostilehosts.cfg");
            if (inStream != null) {
                br = new BufferedReader(new InputStreamReader(inStream));
            } else {
                NLogger.debug("Security", (Object)"Hostile hosts file not found.");
                return;
            }
            while ((line = br.readLine()) != null) {
                int type;
                byte[] mask;
                byte[] ip;
                if (StringUtils.isEmpty(line) || line.startsWith("#")) continue;
                int slashIdx = line.indexOf(47);
                if (slashIdx == -1) {
                    ip = AddressUtils.parseIP(line);
                    mask = null;
                    type = 1;
                } else {
                    String ipStr = line.substring(0, slashIdx).trim();
                    String maskStr = line.substring(slashIdx + 1).trim();
                    ip = AddressUtils.parseIP(ipStr);
                    mask = AddressUtils.parseIP(maskStr);
                    type = 2;
                }
                IPAccessRule rule = new IPAccessRule("System rule.", true, (byte)type, ip, mask, true, true, false);
                XJBSecurityRule xjbRule = this.findSystemXJBRule(systemRuleMap, ip, mask);
                if (xjbRule != null) {
                    rule.setTriggerCount(xjbRule.getTriggerCount());
                }
                this.ipAccessRuleList.add(rule);
                this.fastIpList.add(rule);
            }
            br.close();
            long end = System.currentTimeMillis();
            NLogger.debug("Security", (Object)("Loaded hostile hosts file: " + (end - start)));
        }
        catch (IOException exp) {
            NLogger.warn("Security", (Object)exp, (Throwable)exp);
        }
    }

    private XJBSecurityRule findSystemXJBRule(Map systemRuleMap, byte[] ip, byte[] mask) {
        XJBIPAccessRule xjbRule;
        StringBuffer keyBuf = new StringBuffer(AddressUtils.ip2string(ip));
        if (mask != null) {
            keyBuf.append("-").append(AddressUtils.ip2string(mask));
        }
        if ((xjbRule = (XJBIPAccessRule)systemRuleMap.get(keyBuf.toString())) == null || !xjbRule.isSystemRule()) {
            return null;
        }
        return xjbRule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSecurityRuleList() {
        NLogger.debug("Security", (Object)"Loading security rule list...");
        File securityFile = Environment.getInstance().getPhexConfigFile("security.xml");
        ObjectFactory objFactory = new ObjectFactory();
        try {
            XJBPhex phex;
            if (securityFile.exists()) {
                FileManager fileMgr = FileManager.getInstance();
                ManagedFile managedFile = fileMgr.getReadWriteManagedFile(securityFile);
                phex = XMLBuilder.loadXJBPhexFromFile(managedFile);
            } else {
                phex = objFactory.createXJBPhex();
            }
            XJBSecurity xjbSecurity = phex.getSecurity();
            if (xjbSecurity == null) {
                NLogger.debug("Security", (Object)"No security definition found.");
                xjbSecurity = objFactory.createXJBSecurity();
            }
            List ruleList = xjbSecurity.getIpAccessRuleList();
            ArrayList arrayList = this.ipAccessRuleList;
            synchronized (arrayList) {
                Iterator iterator = ruleList.iterator();
                HashMap<String, XJBIPAccessRule> systemRuleMap = new HashMap<String, XJBIPAccessRule>();
                while (iterator.hasNext()) {
                    XJBIPAccessRule xjbRule = (XJBIPAccessRule)iterator.next();
                    if (!xjbRule.isSystemRule()) {
                        IPAccessRule rule = new IPAccessRule(xjbRule);
                        this.ipAccessRuleList.add(rule);
                        this.fastIpList.add(rule);
                        continue;
                    }
                    StringBuffer keyBuf = new StringBuffer(AddressUtils.ip2string(xjbRule.getIp()));
                    if (xjbRule.getCompareIP() != null) {
                        keyBuf.append("-").append(AddressUtils.ip2string(xjbRule.getCompareIP()));
                    }
                    systemRuleMap.put(keyBuf.toString(), xjbRule);
                }
                this.loadHostileHostList(systemRuleMap);
                this.ipAccessRuleList.trimToSize();
            }
        }
        catch (JAXBException exp) {
            Throwable linkedException = exp.getLinkedException();
            if (linkedException != null) {
                NLogger.error("Security", (Object)linkedException, linkedException);
            }
            NLogger.error("Security", (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("SecuritySettingsLoadFailed", new String[]{exp.toString()});
            return;
        }
        catch (ManagedFileException exp) {
            NLogger.error("Security", (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("SecuritySettingsLoadFailed", new String[]{exp.toString()});
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSecurityRuleList() {
        NLogger.debug("Security", (Object)"Saving security rule list...");
        try {
            ObjectFactory objFactory = new ObjectFactory();
            PhexElement phex = objFactory.createPhexElement();
            XJBSecurity security = objFactory.createXJBSecurity();
            phex.setSecurity(security);
            phex.setPhexVersion(VersionUtils.getFullProgramVersion());
            List ruleList = security.getIpAccessRuleList();
            ArrayList arrayList = this.ipAccessRuleList;
            synchronized (arrayList) {
                Iterator iterator = this.ipAccessRuleList.iterator();
                while (iterator.hasNext()) {
                    IPAccessRule rule = (IPAccessRule)iterator.next();
                    if (!rule.isSystemRule() && rule.isDeletedOnExpiry() && (rule.getExpiryDate().isExpiringEndOfSession() || rule.getExpiryDate().isExpired()) || rule.isSystemRule() && rule.getTriggerCountObject() == 0) continue;
                    XJBSecurityRule xjbRule = rule.createXJBSecurityRule();
                    ruleList.add(xjbRule);
                }
            }
            File securityFile = Environment.getInstance().getPhexConfigFile("security.xml");
            ManagedFile managedFile = FileManager.getInstance().getReadWriteManagedFile(securityFile);
            XMLBuilder.saveToFile(managedFile, phex);
        }
        catch (JAXBException exp) {
            NLogger.error("Security", (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("SecuritySettingsSaveFailed", new String[]{exp.toString()});
        }
        catch (ManagedFileException exp) {
            NLogger.error("Security", (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("SecuritySettingsSaveFailed", new String[]{exp.toString()});
        }
    }

    public static PhexSecurityManager getInstance() {
        return Holder.manager;
    }

    public boolean initialize() {
        return true;
    }

    public boolean onPostInitialization() {
        this.loadSecurityRuleList();
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
        this.saveSecurityRuleList();
    }

    public void addSecurityRuleChangeListener(SecurityRulesChangeListener listener) {
        this.listenerList.add(listener);
    }

    public void removeSecurityRuleChangeListener(SecurityRulesChangeListener listener) {
        this.listenerList.remove(listener);
    }

    private void fireSecurityRuleChanged(final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = PhexSecurityManager.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    SecurityRulesChangeListener listener = (SecurityRulesChangeListener)listeners[i];
                    listener.securityRuleChanged(position);
                }
            }
        });
    }

    private void fireSecurityRuleAdded(final SecurityRule rule, final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = PhexSecurityManager.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    SecurityRulesChangeListener listener = (SecurityRulesChangeListener)listeners[i];
                    listener.securityRuleAdded(rule, position);
                }
            }
        });
    }

    private void fireSecurityRuleRemoved(final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = PhexSecurityManager.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    SecurityRulesChangeListener listener = (SecurityRulesChangeListener)listeners[i];
                    listener.securityRuleRemoved(position);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSecurityRuleChanged(SecurityRule rule) {
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            int position = this.ipAccessRuleList.indexOf(rule);
            if (position >= 0) {
                this.fireSecurityRuleChanged(position);
            }
        }
    }

    private static class Holder {
        protected static final PhexSecurityManager manager = new PhexSecurityManager();

        private Holder() {
        }
    }
}

