/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.File;
import java.util.Iterator;
import phex.common.AltLocContainer;
import phex.common.URN;
import phex.download.swarming.SWDownloadFile;
import phex.http.HTTPRangeSet;
import phex.http.Range;
import phex.share.ShareFile;
import phex.xml.sax.share.DSharedFile;

public class PartialShareFile
extends ShareFile {
    private SWDownloadFile swDownloadFile;
    private HTTPRangeSet availableRangeSet;
    private File partialFile;
    private long fileStartOffset;

    public PartialShareFile(SWDownloadFile downloadFile) {
        super(downloadFile.getTotalDataSize());
        this.swDownloadFile = downloadFile;
        this.availableRangeSet = this.swDownloadFile.createAvailableRangeSet();
    }

    public URN getURN() {
        return this.swDownloadFile.getFileURN();
    }

    public String getSHA1() {
        URN urn = this.swDownloadFile.getFileURN();
        if (urn == null || !urn.isSha1Nid()) {
            return "";
        }
        return urn.getNamespaceSpecificString();
    }

    public String getFileName() {
        return this.swDownloadFile.getDestinationFile().getName();
    }

    public AltLocContainer getAltLocContainer() {
        return this.swDownloadFile.getGoodAltLocContainer();
    }

    public short getRangeAvailableStatus(Range requestedRange) {
        long fileSize = this.getFileSize();
        Iterator iterator = this.availableRangeSet.getIterator();
        while (iterator.hasNext()) {
            Range availableRange = (Range)iterator.next();
            if (!availableRange.isRangeSatisfiable(requestedRange, fileSize)) continue;
            return 0;
        }
        long startOffset = requestedRange.getStartOffset(fileSize);
        if (startOffset < 0L || startOffset >= fileSize) {
            return 2;
        }
        return 1;
    }

    public File getSystemFile() {
        return this.partialFile;
    }

    public String toString() {
        return super.toString() + " - Backed SWDownloadFile: " + this.swDownloadFile.toString();
    }

    public void findFittingPartForRange(Range requestedRange) {
        Iterator iterator = this.availableRangeSet.getIterator();
        long fileSize = this.getFileSize();
        while (iterator.hasNext()) {
            Range availableRange = (Range)iterator.next();
            if (!availableRange.isRangeSatisfiable(requestedRange, fileSize)) continue;
            this.partialFile = this.swDownloadFile.getIncompleteFile();
            long startOffset = requestedRange.getStartOffset(fileSize);
            long endOffset = Math.min(requestedRange.getEndOffset(fileSize), availableRange.getEndOffset(fileSize));
            requestedRange.update(startOffset, endOffset);
            this.fileStartOffset = startOffset;
            return;
        }
    }

    public long getFileStartOffset() {
        return this.fileStartOffset;
    }

    public String buildXAvailableRangesString() {
        return this.availableRangeSet.buildXAvailableRangesString();
    }

    public int getFileIndex() {
        throw new UnsupportedOperationException();
    }

    public void setFileIndex(int index) {
        throw new UnsupportedOperationException();
    }

    public Integer getSearchCountObject() {
        throw new UnsupportedOperationException();
    }

    public int getSearchCount() {
        throw new UnsupportedOperationException();
    }

    public void incSearchCount() {
        throw new UnsupportedOperationException();
    }

    public Integer getUploadCountObject() {
        throw new UnsupportedOperationException();
    }

    public int getUploadCount() {
        throw new UnsupportedOperationException();
    }

    public void incUploadCount() {
    }

    public char[] getSearchCompareTerm() {
        throw new UnsupportedOperationException();
    }

    public void updateFromCache(DSharedFile dFile) {
        throw new UnsupportedOperationException();
    }

    public void calculateURN() {
        throw new UnsupportedOperationException();
    }
}

