/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.TreeMap;
import phex.common.Environment;
import phex.common.RunnerQueueWorker;
import phex.common.ThreadTracking;
import phex.common.URN;
import phex.common.file.FileManager;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.event.AsynchronousDispatcher;
import phex.event.ShareChangeListener;
import phex.share.FileRescanRunner;
import phex.share.ShareFile;
import phex.share.SharedDirectory;
import phex.share.SharedResource;
import phex.share.UrnCalculationWorker;
import phex.thex.ThexCalculationWorker;
import phex.utils.FileUtils;
import phex.utils.NLogger;
import phex.utils.ReadWriteLock;
import phex.utils.VersionUtils;
import phex.xml.sax.DPhex;
import phex.xml.sax.XMLBuilder;
import phex.xml.sax.share.DSharedFile;
import phex.xml.sax.share.DSharedLibrary;

public class SharedFilesService {
    private ReadWriteLock rwLock;
    private HashMap directoryShareMap;
    private ArrayList sharedDirectories;
    private HashMap urnToFileMap;
    private HashMap nameToFileMap;
    private Map timeToFileMap;
    private ArrayList indexedSharedFiles;
    private ArrayList sharedFiles;
    private int totalFileSizeKb;
    private RunnerQueueWorker urnThexCalculationRunner;
    private static Object saveSharedFilesLock;
    private SaveSharedFilesJob saveSharedFilesJob;
    private ArrayList listenerList = new ArrayList(2);
    static final /* synthetic */ boolean $assertionsDisabled;

    public SharedFilesService() {
        this.rwLock = new ReadWriteLock();
        this.urnThexCalculationRunner = new RunnerQueueWorker();
        Environment.getInstance().scheduleTimerTask(new FileRescanTimer(), 60000L, 60000L);
        this.directoryShareMap = new HashMap();
        this.sharedDirectories = new ArrayList();
        this.urnToFileMap = new HashMap();
        this.nameToFileMap = new HashMap();
        this.timeToFileMap = new TreeMap(Collections.reverseOrder());
        this.indexedSharedFiles = new ArrayList();
        this.sharedFiles = new ArrayList();
        this.totalFileSizeKb = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSharedFilePath(File file) {
        this.rwLock.readLock();
        try {
            File highestDir = file.getParentFile();
            Iterator iterator = this.directoryShareMap.keySet().iterator();
            while (iterator.hasNext()) {
                File dir = (File)iterator.next();
                SharedDirectory sharedDir = (SharedDirectory)this.directoryShareMap.get(dir);
                if (sharedDir.getType() != 1 || !FileUtils.isChildOfDir(file, dir) || !FileUtils.isChildOfDir(highestDir, dir)) continue;
                highestDir = dir;
            }
            File highestParent = highestDir.getParentFile();
            if (highestParent != null) {
                highestDir = highestParent;
            }
            String pathStr = highestDir.getAbsolutePath();
            int length = pathStr.length();
            if (!pathStr.endsWith(File.separator)) {
                ++length;
            }
            String string = file.getAbsolutePath().substring(length);
            return string;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error("Sharing", (Object)exp, (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFile getFileByName(String name) {
        this.rwLock.readLock();
        try {
            ShareFile shareFile = (ShareFile)this.nameToFileMap.get(name);
            return shareFile;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error("Sharing", (Object)exp, (Throwable)exp);
            }
        }
    }

    public ShareFile getShareFileByFile(File file) {
        return this.getFileByName(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFile getFileAt(int index) {
        this.rwLock.readLock();
        try {
            if (index >= this.sharedFiles.size()) {
                ShareFile shareFile = null;
                return shareFile;
            }
            ShareFile shareFile = (ShareFile)this.sharedFiles.get(index);
            return shareFile;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error("Sharing", (Object)exp, (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFile[] getSharedFiles() {
        this.rwLock.readLock();
        try {
            ShareFile[] array = new ShareFile[this.sharedFiles.size()];
            ShareFile[] shareFileArray = array = this.sharedFiles.toArray(array);
            return shareFileArray;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error("Sharing", (Object)exp, (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFileCount() {
        this.rwLock.readLock();
        try {
            int n = this.sharedFiles.size();
            return n;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error("Sharing", (Object)exp, (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalFileSizeInKb() {
        this.rwLock.readLock();
        try {
            int n = this.totalFileSizeKb;
            return n;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error("Sharing", (Object)exp, (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFile getFileByIndex(int fileIndex) throws IndexOutOfBoundsException {
        this.rwLock.readLock();
        try {
            if (fileIndex >= this.indexedSharedFiles.size()) {
                ShareFile shareFile = null;
                return shareFile;
            }
            ShareFile shareFile = (ShareFile)this.indexedSharedFiles.get(fileIndex);
            return shareFile;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error("Sharing", (Object)exp, (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFile getFileByURN(URN fileURN) throws IndexOutOfBoundsException {
        this.rwLock.readLock();
        try {
            if (fileURN == null) {
                ShareFile shareFile = null;
                return shareFile;
            }
            ShareFile shareFile = (ShareFile)this.urnToFileMap.get(fileURN);
            return shareFile;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error("Sharing", (Object)exp, (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isURNShared(URN fileURN) throws IndexOutOfBoundsException {
        this.rwLock.readLock();
        try {
            if (fileURN == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.urnToFileMap.containsKey(fileURN);
            return bl;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error("Sharing", (Object)exp, (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFilesByURNs(URN[] urns) {
        this.rwLock.readLock();
        try {
            ArrayList results = new ArrayList(urns.length);
            for (int i = 0; i < urns.length; ++i) {
                Object obj = this.urnToFileMap.get(urns[i]);
                if (obj == null) continue;
                results.add(obj);
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error("Sharing", (Object)exp, (Throwable)exp);
            }
        }
    }

    public ShareFile[] getNewestFiles(int count) {
        ArrayList<ShareFile> fileList = new ArrayList<ShareFile>();
        Iterator iterator = this.timeToFileMap.entrySet().iterator();
        while (iterator.hasNext() && fileList.size() < count) {
            Set fileSet = (Set)iterator.next().getValue();
            Iterator setIterator = fileSet.iterator();
            while (setIterator.hasNext() && fileList.size() < count) {
                ShareFile shareFile = (ShareFile)setIterator.next();
                fileList.add(shareFile);
            }
        }
        ShareFile[] files = new ShareFile[fileList.size()];
        fileList.toArray(files);
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSharedFile(ShareFile shareFile) {
        File file = shareFile.getSystemFile();
        if (this.getFileByName(file.getAbsolutePath()) != null) {
            return;
        }
        this.rwLock.writeLock();
        try {
            int position = this.indexedSharedFiles.size();
            shareFile.setFileIndex(position);
            this.indexedSharedFiles.add(shareFile);
            this.sharedFiles.add(shareFile);
            this.nameToFileMap.put(file.getAbsolutePath(), shareFile);
            this.totalFileSizeKb = (int)((long)this.totalFileSizeKb + file.length() / 1024L);
        }
        finally {
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error("Sharing", (Object)exp, (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTimeToFile(ShareFile shareFile) {
        this.rwLock.writeLock();
        try {
            Long time = shareFile.getNetworkCreateTime();
            HashSet<ShareFile> shareFileSet = (HashSet<ShareFile>)this.timeToFileMap.get(time);
            if (shareFileSet == null) {
                shareFileSet = new HashSet<ShareFile>();
                this.timeToFileMap.put(time, shareFileSet);
            }
            shareFileSet.add(shareFile);
        }
        finally {
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error("Sharing", (Object)exp, (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSharedFile(ShareFile shareFile) {
        this.rwLock.writeLock();
        try {
            int fileIndex = shareFile.getFileIndex();
            this.indexedSharedFiles.set(fileIndex, null);
            File file = shareFile.getSystemFile();
            this.urnToFileMap.remove(shareFile.getURN());
            this.nameToFileMap.remove(file.getAbsolutePath());
            this.removeTimeToFile(shareFile);
            int position = this.sharedFiles.indexOf(shareFile);
            if (position != -1) {
                this.sharedFiles.remove(position);
                this.totalFileSizeKb = (int)((long)this.totalFileSizeKb - shareFile.getFileSize() / 1024L);
            }
        }
        finally {
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error("Sharing", (Object)exp, (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTimeToFile(ShareFile shareFile) {
        this.rwLock.writeLock();
        try {
            Long time = shareFile.getNetworkCreateTime();
            Set shareFileSet = (Set)this.timeToFileMap.get(time);
            if (shareFileSet == null) {
                return;
            }
            shareFileSet.remove(shareFile);
            if (shareFileSet.size() == 0) {
                this.timeToFileMap.remove(time);
            }
        }
        finally {
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error("Sharing", (Object)exp, (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSharedDirecotries(HashMap sharedDirectoryMap, HashSet sharedDirectoryList) {
        this.rwLock.writeLock();
        try {
            this.directoryShareMap.clear();
            this.directoryShareMap.putAll(sharedDirectoryMap);
            this.sharedDirectories.clear();
            this.sharedDirectories.addAll(sharedDirectoryList);
            this.sharedDirectoriesChanged();
        }
        finally {
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error("Sharing", (Object)exp, (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedDirectory[] getSharedDirectories() {
        this.rwLock.readLock();
        try {
            SharedDirectory[] array = new SharedDirectory[this.sharedDirectories.size()];
            SharedDirectory[] sharedDirectoryArray = array = this.sharedDirectories.toArray(array);
            return sharedDirectoryArray;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error("Sharing", (Object)exp, (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedDirectory getSharedDirectory(File file) {
        if (!file.isDirectory()) {
            return null;
        }
        this.rwLock.readLock();
        try {
            SharedResource resource = (SharedResource)this.directoryShareMap.get(file);
            if (resource instanceof SharedDirectory) {
                SharedDirectory sharedDirectory = (SharedDirectory)resource;
                return sharedDirectory;
            }
            SharedDirectory sharedDirectory = null;
            return sharedDirectory;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error("Sharing", (Object)exp, (Throwable)exp);
            }
        }
    }

    public void addUrn2FileMapping(ShareFile shareFile) {
        if (!$assertionsDisabled && shareFile.getURN() == null) {
            throw new AssertionError();
        }
        this.urnToFileMap.put(shareFile.getURN(), shareFile);
        this.addTimeToFile(shareFile);
    }

    public void queueUrnCalculation(ShareFile shareFile) {
        UrnCalculationWorker worker = new UrnCalculationWorker(shareFile);
        this.urnThexCalculationRunner.add(worker);
    }

    public void queueThexCalculation(ShareFile shareFile) {
        ThexCalculationWorker worker = new ThexCalculationWorker(shareFile);
        this.urnThexCalculationRunner.add(worker);
    }

    public void setCalculationRunnerPause(boolean state) {
        this.urnThexCalculationRunner.setPause(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSharedFiles() {
        this.rwLock.writeLock();
        try {
            this.urnThexCalculationRunner.stopAndClear();
            this.sharedFiles.clear();
            this.indexedSharedFiles.clear();
            this.urnToFileMap.clear();
            this.nameToFileMap.clear();
            this.timeToFileMap.clear();
            this.totalFileSizeKb = 0;
        }
        finally {
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error("Sharing", (Object)exp, (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerSaveSharedFiles() {
        NLogger.debug("Sharing", (Object)"Trigger save shared files...");
        Object object = saveSharedFilesLock;
        synchronized (object) {
            if (this.saveSharedFilesJob != null) {
                this.saveSharedFilesJob.triggerFollowUpSave();
            } else {
                this.saveSharedFilesJob = new SaveSharedFilesJob();
                this.saveSharedFilesJob.start();
            }
        }
    }

    public DSharedLibrary loadSharedLibrary() {
        DPhex dPhex;
        NLogger.debug("Sharing", (Object)"Load shared library configuration file.");
        File file = Environment.getInstance().getPhexConfigFile("sharedlibrary.xml");
        try {
            ManagedFile managedFile = FileManager.getInstance().getReadWriteManagedFile(file);
            dPhex = XMLBuilder.loadDPhexFromFile(managedFile);
            if (dPhex == null) {
                NLogger.debug("Sharing", (Object)"No shared library configuration file found.");
                return null;
            }
        }
        catch (InterruptedIOException exp) {
            return null;
        }
        catch (IOException exp) {
            NLogger.error("Sharing", (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("SharedFilesLoadFailed", new String[]{exp.toString()});
            return null;
        }
        catch (ManagedFileException exp) {
            NLogger.error("Sharing", (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("SharedFilesLoadFailed", new String[]{exp.toString()});
            return null;
        }
        DSharedLibrary sharedLibrary = dPhex.getSharedLibrary();
        return sharedLibrary;
    }

    public void addSharedFilesChangeListener(ShareChangeListener listener) {
        this.listenerList.add(listener);
    }

    public void removeSharedFilesChangeListener(ShareChangeListener listener) {
        this.listenerList.remove(listener);
    }

    private void sharedDirectoriesChanged() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = SharedFilesService.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    ShareChangeListener listener = (ShareChangeListener)listeners[i];
                    listener.sharedDirectoriesChanged();
                }
            }
        });
    }

    static {
        $assertionsDisabled = !SharedFilesService.class.desiredAssertionStatus();
        saveSharedFilesLock = new Object();
    }

    private class SaveSharedFilesJob
    extends Thread {
        private boolean isFollowUpSaveTriggered;

        public SaveSharedFilesJob() {
            super(ThreadTracking.rootThreadGroup, "SaveSharedFilesJob");
            this.setPriority(1);
        }

        public void triggerFollowUpSave() {
            this.isFollowUpSaveTriggered = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FileManager fileMgr = FileManager.getInstance();
            File libraryFile = Environment.getInstance().getPhexConfigFile("sharedlibrary.xml");
            File tmpFile = Environment.getInstance().getPhexConfigFile("sharedlibrary.xml.tmp");
            do {
                NLogger.debug("Sharing", (Object)"Saving shared library.");
                this.isFollowUpSaveTriggered = false;
                SharedFilesService.this.rwLock.readLock();
                try {
                    DPhex dPhex = new DPhex();
                    dPhex.setPhexVersion(VersionUtils.getFullProgramVersion());
                    DSharedLibrary dLibrary = this.createDSharedLibrary();
                    dPhex.setSharedLibrary(dLibrary);
                    ManagedFile tmpMgFile = fileMgr.getReadWriteManagedFile(tmpFile);
                    XMLBuilder.saveToFile(tmpMgFile, dPhex);
                    ManagedFile libraryMgFile = fileMgr.getReadWriteManagedFile(libraryFile);
                    try {
                        libraryMgFile.acquireFileLock();
                        FileUtils.copyFile(tmpFile, libraryFile);
                    }
                    finally {
                        libraryMgFile.releaseFileLock();
                    }
                }
                catch (ManagedFileException exp) {
                    if (exp.getCause() instanceof InterruptedException) {
                        NLogger.debug("Sharing", (Object)exp);
                        continue;
                    }
                    NLogger.error("Sharing", (Object)exp, (Throwable)exp);
                    Environment.getInstance().fireDisplayUserMessage("SharedFilesSaveFailed", new String[]{exp.toString()});
                    NLogger.error("Sharing", (Object)exp, (Throwable)exp);
                }
                catch (IOException exp) {
                    NLogger.error("Sharing", (Object)exp, (Throwable)exp);
                    Environment.getInstance().fireDisplayUserMessage("SharedFilesSaveFailed", new String[]{exp.toString()});
                }
                finally {
                    try {
                        SharedFilesService.this.rwLock.readUnlock();
                    }
                    catch (IllegalAccessException exp) {
                        NLogger.error("Sharing", (Object)exp, (Throwable)exp);
                    }
                }
            } while (this.isFollowUpSaveTriggered);
            NLogger.debug("Sharing", (Object)"Finished saving download list...");
            Object object = saveSharedFilesLock;
            synchronized (object) {
                SharedFilesService.this.saveSharedFilesJob = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DSharedLibrary createDSharedLibrary() {
            DSharedLibrary library = new DSharedLibrary();
            SharedFilesService.this.rwLock.readLock();
            try {
                Iterator iterator = SharedFilesService.this.sharedFiles.iterator();
                List sharedFileList = library.getSubElementList();
                while (iterator.hasNext()) {
                    try {
                        ShareFile file = (ShareFile)iterator.next();
                        if (file.getURN() == null) continue;
                        DSharedFile dFile = file.createDSharedFile();
                        sharedFileList.add(dFile);
                    }
                    catch (Exception exp) {
                        NLogger.error("Sharing", (Object)"SharedFile skipped due to error.", (Throwable)exp);
                    }
                }
            }
            finally {
                try {
                    SharedFilesService.this.rwLock.readUnlock();
                }
                catch (IllegalAccessException exp) {
                    NLogger.error("Sharing", (Object)exp, (Throwable)exp);
                }
            }
            return library;
        }
    }

    private class FileRescanTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 60000L;

        private FileRescanTimer() {
        }

        public void run() {
            try {
                FileRescanRunner.rescan(false, false);
            }
            catch (Throwable th) {
                NLogger.error("Sharing", (Object)th, th);
            }
        }
    }
}

