/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import com.bitzi.util.Base32;
import com.bitzi.util.SHA1;
import java.io.FileInputStream;
import java.io.IOException;
import phex.common.AltLocContainer;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.share.SharedFilesService;
import phex.utils.IOUtil;
import phex.utils.Logger;
import phex.utils.NLogger;

class UrnCalculationWorker
implements Runnable {
    private ShareFile shareFile;

    UrnCalculationWorker(ShareFile shareFile) {
        this.shareFile = shareFile;
    }

    public void run() {
        boolean succ = this.calculateURN();
        if (succ) {
            SharedFilesService sharedFilesService = ShareManager.getInstance().getSharedFilesService();
            sharedFilesService.addUrn2FileMapping(this.shareFile);
            sharedFilesService.triggerSaveSharedFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean calculateURN() {
        boolean bl;
        short urnCalculationMode = ServiceManager.sCfg.urnCalculationMode;
        FileInputStream inStream = null;
        try {
            SwarmingManager swarmingMgr;
            SWDownloadFile file;
            int length;
            inStream = new FileInputStream(this.shareFile.getSystemFile());
            SHA1 messageDigest = new SHA1();
            byte[] buffer = new byte[65536];
            long start = System.currentTimeMillis();
            long start2 = System.currentTimeMillis();
            while ((length = inStream.read(buffer)) != -1) {
                messageDigest.update(buffer, 0, length);
                long end2 = System.currentTimeMillis();
                try {
                    Thread.sleep((end2 - start2) * (long)urnCalculationMode);
                }
                catch (InterruptedException exp) {
                    Thread.currentThread().interrupt();
                    boolean bl2 = false;
                    IOUtil.closeQuietly(inStream);
                    return bl2;
                }
                start2 = System.currentTimeMillis();
            }
            inStream.close();
            byte[] shaDigest = messageDigest.digest();
            long end = System.currentTimeMillis();
            URN urn = new URN("urn:sha1:" + Base32.encode(shaDigest));
            this.shareFile.setURN(urn);
            if (Logger.isLevelTypeLogged(Logger.FINEST, (short)4)) {
                Logger.logMessage(Logger.FINEST, (short)4, "SHA1 time: " + (end - start) + " size: " + this.shareFile.getSystemFile().length());
            }
            if ((file = (swarmingMgr = SwarmingManager.getInstance()).getDownloadFileByURN(urn)) != null) {
                AltLocContainer altCont = file.getGoodAltLocContainer();
                this.shareFile.getAltLocContainer().addContainer(altCont);
            }
            bl = true;
        }
        catch (IOException exp) {
            boolean bl3;
            try {
                NLogger.debug(UrnCalculationWorker.class, (Object)exp, (Throwable)exp);
                bl3 = false;
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(inStream);
                throw throwable;
            }
            IOUtil.closeQuietly(inStream);
            return bl3;
        }
        IOUtil.closeQuietly(inStream);
        return bl;
    }
}

