/*
 * Decompiled with CFR 0.152.
 */
package phex.share.export;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import phex.common.ThreadPool;
import phex.share.export.SharedFilesPipeFiller;
import phex.utils.IOUtil;
import phex.utils.NLogger;

public class ExportEngine {
    public static final String USE_MAGNET_URL_WITH_XS = "UseMagnetURLWithXS";
    private Map exportOptions = null;

    public void setExportOptions(Map options) {
        this.exportOptions = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startExport(InputStream styleSheetStream, OutputStream destinationStream) {
        PipedOutputStream pipedOutStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream();
        try {
            pipedOutStream.connect(pipedInputStream);
            SharedFilesPipeFiller fillerRunnable = new SharedFilesPipeFiller(pipedOutStream, this.exportOptions);
            ThreadPool.getInstance().addJob(fillerRunnable, "SharedFilesPipeFiller");
            StreamSource styleSheetSource = new StreamSource(styleSheetStream);
            StreamSource dataSource = new StreamSource(pipedInputStream);
            StreamResult result = new StreamResult(destinationStream);
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer(styleSheetSource);
                transformer.transform(dataSource, result);
            }
            catch (TransformerException exp) {
                NLogger.error("Sharing", (Object)exp, (Throwable)exp);
            }
        }
        catch (IOException exp) {
            NLogger.error("Sharing", (Object)exp, (Throwable)exp);
        }
        finally {
            IOUtil.closeQuietly(pipedInputStream);
            IOUtil.closeQuietly(pipedOutStream);
        }
    }
}

