/*
 * Decompiled with CFR 0.152.
 */
package phex.thex;

import com.bitzi.util.Base32;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;
import phex.share.ShareFile;
import phex.thex.TTHashCalcUtils;
import phex.utils.NLogger;

public class ShareFileThexData {
    private ShareFile shareFile;
    private String rootHash;
    private List lowestLevelNodes;
    private int treeDepth;

    public ShareFileThexData(ShareFile shareFile, byte[] rootHash, List lowestLevelNodes, int depth) {
        this.shareFile = shareFile;
        this.rootHash = Base32.encode(rootHash);
        this.lowestLevelNodes = lowestLevelNodes;
        this.treeDepth = depth;
    }

    public ShareFileThexData(ShareFile shareFile, String rootHash, String xjbLowestLevelNodes, int depth) {
        this.shareFile = shareFile;
        this.rootHash = rootHash;
        this.lowestLevelNodes = ShareFileThexData.parseXJBLowestLevelNodes(xjbLowestLevelNodes);
        this.treeDepth = depth;
    }

    public String getRootHash() {
        return this.rootHash;
    }

    public int getTreeDepth() {
        return this.treeDepth;
    }

    public byte[] getSerializedTreeNodes() {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        List allNodes = TTHashCalcUtils.calculateMerkleParentNodes(this.lowestLevelNodes);
        Iterator iterator = allNodes.iterator();
        try {
            while (iterator.hasNext()) {
                Iterator subIterator = ((List)iterator.next()).iterator();
                while (subIterator.hasNext()) {
                    outStream.write((byte[])subIterator.next());
                }
            }
        }
        catch (IOException exp) {
            NLogger.error("GLOBAL", (Object)exp, (Throwable)exp);
            throw new RuntimeException(exp);
        }
        return outStream.toByteArray();
    }

    public String getXJBLowestLevelNodes() {
        Iterator iterator = this.lowestLevelNodes.iterator();
        StringBuffer xjbString = new StringBuffer();
        while (iterator.hasNext()) {
            byte[] nodeData = (byte[])iterator.next();
            String node = new String(Base64.encodeBase64(nodeData));
            xjbString.append(node);
            xjbString.append("-");
        }
        return xjbString.toString();
    }

    public void updateFromCache(String rootHash, String xjbLowestLevelNodes, int depth) {
        this.rootHash = rootHash;
        this.lowestLevelNodes = ShareFileThexData.parseXJBLowestLevelNodes(xjbLowestLevelNodes);
        this.treeDepth = depth;
    }

    private static List parseXJBLowestLevelNodes(String xjbString) {
        StringTokenizer tokenizer = new StringTokenizer(xjbString, "-");
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        while (tokenizer.hasMoreTokens()) {
            String node = tokenizer.nextToken();
            byte[] nodeData = Base64.decodeBase64(node.getBytes());
            list.add(nodeData);
        }
        return list;
    }
}

