/*
 * Decompiled with CFR 0.152.
 */
package phex.thex;

import com.bitzi.util.Tiger;
import com.bitzi.util.TigerTree;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import phex.common.ServiceManager;
import phex.share.ShareFile;
import phex.thex.ShareFileThexData;
import phex.utils.IOUtil;
import phex.utils.NLogger;

public class TTHashCalcUtils {
    private static final transient byte MERKLE_IH_PREFIX = 1;
    private static final int THEX_BLOCK_SIZE = 1024;

    public static void calculateShareFileThexData(ShareFile shareFile) throws IOException {
        if (shareFile.getThexData(false) != null) {
            return;
        }
        long fileSize = shareFile.getFileSize();
        int levels = TTHashCalcUtils.getTreeLevels(fileSize);
        int nodeSize = TTHashCalcUtils.getTreeNodeSize(fileSize, levels);
        BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(shareFile.getSystemFile()));
        List lowestLevelNodes = TTHashCalcUtils.calculateTigerTreeNodes(nodeSize, fileSize, inStream);
        List merkleTreeNodes = TTHashCalcUtils.calculateMerkleParentNodes(lowestLevelNodes);
        byte[] rootHash = (byte[])((List)merkleTreeNodes.get(0)).get(0);
        int depth = merkleTreeNodes.size() - 1;
        ShareFileThexData data = new ShareFileThexData(shareFile, rootHash, lowestLevelNodes, depth);
        shareFile.setThexData(data);
    }

    private static int getTreeLevels(long fileSize) {
        if (fileSize < 262144L) {
            return 0;
        }
        if (fileSize < 524288L) {
            return 1;
        }
        if (fileSize < 0x100000L) {
            return 2;
        }
        if (fileSize < 0x200000L) {
            return 3;
        }
        if (fileSize < 0x400000L) {
            return 4;
        }
        if (fileSize < 0x800000L) {
            return 5;
        }
        if (fileSize < 0x1000000L) {
            return 6;
        }
        if (fileSize < 0x2000000L) {
            return 7;
        }
        if (fileSize < 0x4000000L) {
            return 8;
        }
        if (fileSize < 0x10000000L) {
            return 9;
        }
        if (fileSize < 0x40000000L) {
            return 10;
        }
        return 11;
    }

    private static int getTreeNodeSize(long fileSize, int depth) {
        int nodes = (int)Math.pow(2.0, depth);
        int fileNodeSize = (int)Math.ceil((double)fileSize / (double)nodes);
        byte pow = IOUtil.calculateCeilLog2(fileNodeSize);
        int nodeSize = (int)Math.pow(2.0, pow);
        return nodeSize;
    }

    private static List calculateTigerTreeNodes(int nodeSize, long fileSize, InputStream inStream) throws IOException {
        short thexCalculationMode = ServiceManager.sCfg.thexCalculationMode;
        int nodeCount = (int)Math.ceil((double)fileSize / (double)nodeSize);
        ArrayList<byte[]> nodeList = new ArrayList<byte[]>(nodeCount);
        TigerTree tigerTreeDigest = new TigerTree();
        long totalRead = 0L;
        int readCount = 0;
        byte[] buffer = new byte[131072];
        while (totalRead < fileSize && readCount != -1) {
            tigerTreeDigest.reset();
            int nodePos = 0;
            long start = System.currentTimeMillis();
            while (nodePos < nodeSize && (readCount = inStream.read(buffer)) != -1) {
                tigerTreeDigest.update(buffer, 0, readCount);
                nodePos += readCount;
                totalRead += (long)readCount;
                try {
                    long end = System.currentTimeMillis();
                    Thread.sleep((end - start) * (long)thexCalculationMode);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Hashing file interrupted.");
                }
                start = System.currentTimeMillis();
            }
            nodeList.add(tigerTreeDigest.digest());
            if (readCount != -1 || totalRead == fileSize) continue;
            NLogger.error("Thex.Calculation", "Hashing file failed.");
            throw new IOException("Hashing file failed.");
        }
        return nodeList;
    }

    public static List calculateMerkleParentNodes(List childNodes) {
        ArrayList<List<Object>> merkleTreeNodes = new ArrayList<List<Object>>();
        merkleTreeNodes.add(Collections.unmodifiableList(childNodes));
        ArrayList<byte[]> tmpNodes = childNodes;
        while (tmpNodes.size() > 1) {
            Tiger md = new Tiger();
            int size = (int)Math.ceil((double)tmpNodes.size() / 2.0);
            ArrayList<byte[]> parentNodes = new ArrayList<byte[]>(size);
            Iterator iterator = tmpNodes.iterator();
            while (iterator.hasNext()) {
                byte[] left = (byte[])iterator.next();
                if (iterator.hasNext()) {
                    byte[] right = (byte[])iterator.next();
                    md.reset();
                    md.update((byte)1);
                    md.update(left, 0, left.length);
                    md.update(right, 0, right.length);
                    byte[] result = md.digest();
                    parentNodes.add(result);
                    continue;
                }
                parentNodes.add(left);
            }
            merkleTreeNodes.add(0, parentNodes);
            tmpNodes = parentNodes;
        }
        return merkleTreeNodes;
    }
}

