/*
 * Decompiled with CFR 0.152.
 */
package phex.udp.hostcache;

import phex.common.AbstractManager;
import phex.common.ThreadPool;
import phex.udp.hostcache.UdpHostCacheContainer;
import phex.utils.NLogger;

public class UdpHostCacheManager
extends AbstractManager {
    private UdpHostCacheContainer udpHostCacheContainer;
    private boolean isThreadRequestRunning = false;

    public static UdpHostCacheManager getInstance() {
        return Holder.manager;
    }

    public UdpHostCacheContainer getUdpHostCacheContainer() {
        return this.udpHostCacheContainer;
    }

    public boolean isUdpHostCache() {
        return false;
    }

    public synchronized void invokeQueryCachesRequest() {
        if (this.isThreadRequestRunning) {
            return;
        }
        this.isThreadRequestRunning = true;
        QueryCachesRunner runner = new QueryCachesRunner();
        ThreadPool.getInstance().addJob(runner, "UdpHostCacheQuery-" + Integer.toHexString(runner.hashCode()));
    }

    public boolean initialize() {
        this.udpHostCacheContainer = new UdpHostCacheContainer();
        NLogger.info("UDP_HOST_CACHE", (Object)"Starting Udp Host Cache Manager");
        return true;
    }

    public boolean onPostInitialization() {
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
        NLogger.info("UDP_HOST_CACHE", (Object)" UDP HOST CACHE MANAGER  SHUTTING DOWN. Writing caches to file");
        this.udpHostCacheContainer.saveCachesToFile();
    }

    private final class QueryCachesRunner
    implements Runnable {
        private QueryCachesRunner() {
        }

        public void run() {
            UdpHostCacheManager.this.udpHostCacheContainer.queryMoreHosts();
            UdpHostCacheManager.this.isThreadRequestRunning = false;
        }
    }

    private static class Holder {
        protected static final UdpHostCacheManager manager = new UdpHostCacheManager();

        private Holder() {
        }
    }
}

