/*
 * Decompiled with CFR 0.152.
 */
package phex.update;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.SystemUtils;
import phex.common.Cfg;
import phex.common.Environment;
import phex.common.IntObj;
import phex.common.LongObj;
import phex.common.ServiceManager;
import phex.event.UpdateNotificationListener;
import phex.gui.common.GUIRegistry;
import phex.share.ShareManager;
import phex.share.SharedFilesService;
import phex.statistic.StatisticProvider;
import phex.statistic.StatisticsManager;
import phex.utils.IOUtil;
import phex.utils.NLogger;
import phex.utils.VersionUtils;
import phex.xml.XJBPhex;
import phex.xml.XJBUpdateResponse;
import phex.xml.XMLBuilder;
import phex.xml.sax.DPhex;
import phex.xml.sax.DUpdateRequest;

public class UpdateCheckRunner
implements Runnable {
    private static final String UPDATE_CHECK_URL = "http://phex.kouk.de/update/update.php";
    private Throwable updateCheckError;
    private UpdateNotificationListener listener;
    private String releaseVersion;
    private String betaVersion;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UpdateCheckRunner(UpdateNotificationListener updateListener) {
        this.listener = updateListener;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getBetaVersion() {
        return this.betaVersion;
    }

    public Throwable getUpdateCheckError() {
        return this.updateCheckError;
    }

    public void run() {
        try {
            this.performUpdateCheck();
        }
        catch (Throwable exp) {
            this.updateCheckError = exp;
            NLogger.warn("GLOBAL", (Object)exp, exp);
        }
    }

    private void performUpdateCheck() {
        XJBPhex xjbPhex;
        try {
            URL url = new URL(UPDATE_CHECK_URL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setUseCaches(false);
            connection.setRequestProperty("User-Agent", Environment.getPhexVendor());
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "text/xml; charset=UTF-8");
            OutputStream outStream = connection.getOutputStream();
            byte[] data = this.buildXMLUpdateRequest();
            if (data == null) {
                throw new IOException("Missing XML update data");
            }
            outStream.write(data);
            if (NLogger.isDebugEnabled("UpdateCheck.Request")) {
                NLogger.debug("UpdateCheck.Request", (Object)new String(data));
            }
            InputStream inStream = connection.getInputStream();
            if (NLogger.isDebugEnabled("UpdateCheck.Response")) {
                byte[] respData = IOUtil.toByteArray(inStream);
                NLogger.debug("UpdateCheck.Response", (Object)new String(respData));
                inStream = new ByteArrayInputStream(respData);
            }
            xjbPhex = XMLBuilder.readXJBPhexFromStream(inStream);
        }
        catch (MalformedURLException exp) {
            this.updateCheckError = exp;
            NLogger.warn("GLOBAL", (Object)exp, (Throwable)exp);
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            throw new RuntimeException();
        }
        catch (UnknownHostException exp) {
            this.updateCheckError = exp;
            NLogger.warn("GLOBAL", (Object)exp, (Throwable)exp);
            return;
        }
        catch (SocketException exp) {
            this.updateCheckError = exp;
            NLogger.warn("GLOBAL", (Object)exp, (Throwable)exp);
            return;
        }
        catch (IOException exp) {
            this.updateCheckError = exp;
            NLogger.warn("GLOBAL", (Object)exp, (Throwable)exp);
            return;
        }
        catch (JAXBException exp) {
            this.updateCheckError = exp;
            NLogger.warn("GLOBAL", (Object)exp, (Throwable)exp);
            return;
        }
        ServiceManager.sCfg.lastUpdateCheckTime = System.currentTimeMillis();
        XJBUpdateResponse response = xjbPhex.getUpdateResponse();
        List versionList = response.getVersionList();
        Iterator versionIterator = versionList.iterator();
        XJBUpdateResponse.VersionType latestReleaseVersion = null;
        XJBUpdateResponse.VersionType latestBetaVersion = null;
        while (versionIterator.hasNext()) {
            XJBUpdateResponse.VersionType currentVersion = (XJBUpdateResponse.VersionType)versionIterator.next();
            if (currentVersion.isBeta()) {
                if (latestBetaVersion != null && VersionUtils.compare(currentVersion.getId(), latestBetaVersion.getId()) <= 0) continue;
                latestBetaVersion = currentVersion;
                continue;
            }
            if (latestReleaseVersion != null && VersionUtils.compare(currentVersion.getId(), latestReleaseVersion.getId()) <= 0) continue;
            latestReleaseVersion = currentVersion;
        }
        this.betaVersion = "0";
        this.releaseVersion = "0";
        if (latestBetaVersion != null) {
            this.betaVersion = latestBetaVersion.getId();
        }
        if (latestReleaseVersion != null) {
            this.releaseVersion = latestReleaseVersion.getId();
        }
        int releaseCompare = 0;
        int betaCompare = 0;
        betaCompare = VersionUtils.compare(this.betaVersion, VersionUtils.getFullProgramVersion());
        releaseCompare = VersionUtils.compare(this.releaseVersion, VersionUtils.getFullProgramVersion());
        if (releaseCompare <= 0 && betaCompare <= 0) {
            ServiceManager.sCfg.save();
            return;
        }
        betaCompare = VersionUtils.compare(this.betaVersion, ServiceManager.sCfg.lastBetaUpdateCheckVersion);
        releaseCompare = VersionUtils.compare(this.releaseVersion, ServiceManager.sCfg.lastUpdateCheckVersion);
        int verDiff = VersionUtils.compare(this.betaVersion, this.releaseVersion);
        boolean triggerUpdateNotification = false;
        if (releaseCompare > 0) {
            ServiceManager.sCfg.lastUpdateCheckVersion = this.releaseVersion;
            triggerUpdateNotification = true;
        }
        if (betaCompare > 0) {
            ServiceManager.sCfg.lastBetaUpdateCheckVersion = this.betaVersion;
            triggerUpdateNotification = true;
        }
        if (verDiff > 0) {
            this.releaseVersion = null;
        } else {
            this.betaVersion = null;
        }
        ServiceManager.sCfg.save();
        if (triggerUpdateNotification) {
            this.fireUpdateNotification();
        }
    }

    private void fireUpdateNotification() {
        this.listener.updateNotification(this);
    }

    private byte[] buildXMLUpdateRequest() {
        try {
            Cfg cfg = ServiceManager.sCfg;
            DPhex dPhex = new DPhex();
            DUpdateRequest dRequest = new DUpdateRequest();
            dPhex.setUpdateRequest(dRequest);
            dRequest.setCurrentVersion(VersionUtils.getFullProgramVersion());
            dRequest.setStartupCount(cfg.totalStartupCounter);
            dRequest.setLafUsed(GUIRegistry.getInstance().getUsedLAFClass());
            dRequest.setJavaVersion(System.getProperty("java.version"));
            dRequest.setOperatingSystem(SystemUtils.OS_NAME);
            dRequest.setHostid(cfg.mProgramClientID.toHexString());
            dRequest.setShowBetaInfo(cfg.showBetaUpdateNotification);
            dRequest.setLastInfoId(cfg.lastShownUpdateInfoId);
            String lastCheckVersion = VersionUtils.compare(cfg.lastUpdateCheckVersion, cfg.lastBetaUpdateCheckVersion) > 0 ? cfg.lastUpdateCheckVersion : cfg.lastBetaUpdateCheckVersion;
            dRequest.setLastCheckVersion(lastCheckVersion);
            StatisticsManager statMgr = StatisticsManager.getInstance();
            StatisticProvider uptimeProvider = statMgr.getStatisticProvider("UptimeProvider");
            dRequest.setAvgUptime(((LongObj)uptimeProvider.getAverageValue()).value);
            StatisticProvider dailyUptimeProvider = statMgr.getStatisticProvider("DailyUptimeProvider");
            dRequest.setDailyAvgUptime(((IntObj)dailyUptimeProvider.getValue()).value);
            StatisticProvider downloadProvider = statMgr.getStatisticProvider("TotalDownloadCountProvider");
            dRequest.setDownloadCount((int)((LongObj)downloadProvider.getValue()).value);
            StatisticProvider uploadProvider = statMgr.getStatisticProvider("TotalUploadCountProvider");
            dRequest.setUploadCount((int)((LongObj)uploadProvider.getValue()).value);
            SharedFilesService sharedFilesService = ShareManager.getInstance().getSharedFilesService();
            dRequest.setSharedFiles(sharedFilesService.getFileCount());
            dRequest.setSharedSize(sharedFilesService.getTotalFileSizeInKb());
            dRequest.setErrorLog(this.getErrorLogFileTail());
            return phex.xml.sax.XMLBuilder.serializeToBytes(dPhex);
        }
        catch (IOException exp) {
            NLogger.error("GLOBAL", (Object)exp, (Throwable)exp);
            return null;
        }
    }

    private String getErrorLogFileTail() {
        try {
            File logFile = Environment.getInstance().getPhexConfigFile("phex.error.log");
            if (!logFile.exists()) {
                return null;
            }
            RandomAccessFile raf = new RandomAccessFile(logFile, "r");
            long pos = Math.max(raf.length() - 10240L, 0L);
            raf.seek(pos);
            byte[] buffer = new byte[10240];
            int lenRead = raf.read(buffer);
            return new String(buffer, 0, lenRead);
        }
        catch (IOException exp) {
            NLogger.error("GLOBAL", (Object)exp, (Throwable)exp);
            return exp.toString();
        }
    }

    static {
        $assertionsDisabled = !UpdateCheckRunner.class.desiredAssertionStatus();
    }
}

