/*
 * Decompiled with CFR 0.152.
 */
package phex.update;

import phex.common.Manager;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.ThreadTracking;
import phex.event.UpdateNotificationListener;
import phex.update.UpdateCheckRunner;

public class UpdateManager
implements Manager {
    private static final long ONE_WEEK_MILLIS = 604800000L;
    private static UpdateManager instance;

    public static UpdateManager getInstance() {
        if (instance == null) {
            instance = new UpdateManager();
        }
        return instance;
    }

    public boolean initialize() {
        return false;
    }

    public boolean onPostInitialization() {
        return false;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
    }

    public void triggerAutoBackgroundCheck(final UpdateNotificationListener updateListener) {
        if (ServiceManager.sCfg.lastUpdateCheckTime > System.currentTimeMillis() - 604800000L) {
            return;
        }
        Runnable updateCheckTrigger = new Runnable(){

            public void run() {
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                UpdateCheckRunner runner = new UpdateCheckRunner(updateListener);
                Thread thread = new Thread(ThreadTracking.rootThreadGroup, runner, "UpdateCheckRunner");
                thread.setPriority(1);
                thread.setDaemon(true);
                thread.start();
            }
        };
        ThreadPool.getInstance().addJob(updateCheckTrigger, "UpdateCheckTrigger");
    }
}

