/*
 * Decompiled with CFR 0.152.
 */
package phex.upload;

import com.onionnetworks.dime.DimeGenerator;
import com.onionnetworks.dime.DimeRecord;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import phex.common.AltLocContainer;
import phex.common.AlternateLocation;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.common.address.AddressUtils;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.bandwidth.BandwidthController;
import phex.common.bandwidth.BandwidthManager;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.http.GnutellaRequest;
import phex.http.HTTPHeader;
import phex.http.HTTPMessageException;
import phex.http.HTTPProcessor;
import phex.http.HTTPRangeSet;
import phex.http.HTTPRequest;
import phex.http.HTTPResponse;
import phex.http.Range;
import phex.http.XQueueParameters;
import phex.net.connection.Connection;
import phex.net.presentation.SocketFacade;
import phex.share.PartialShareFile;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.share.SharedFilesService;
import phex.statistic.SimpleStatisticProvider;
import phex.statistic.StatisticsManager;
import phex.thex.ShareFileThexData;
import phex.upload.UploadManager;
import phex.upload.UploadState;
import phex.utils.GnutellaOutputStream;
import phex.utils.IOUtil;
import phex.utils.NLogger;
import phex.utils.StringUtils;
import phex.utils.URLUtil;
import phex.utils.VendorCodes;
import phex.xml.thex.ThexHashTree;
import phex.xml.thex.ThexHashTreeCodec;

public class UploadEngine {
    private static final int BUFFER_LENGTH = 16384;
    private RandomAccessFile raFile;
    private final Connection connection;
    private boolean isUploadQueued;
    private long minNextPollTime;
    private long startOffset;
    private long endOffset;
    private long fileStartOffset;
    private HTTPRequest httpRequest;
    private UploadState uploadState;
    private boolean isIPCounted;
    private DestAddress hostAddress;
    private Set sendAltLocSet;
    public boolean isUploadCounted;
    private boolean isPersistentConnection;
    private ShareFile uploadShareFile;

    public UploadEngine(Connection connection, HTTPRequest httpRequest) {
        this.connection = connection;
        connection.setBandwidthController(BandwidthManager.getInstance().getUploadBandwidthController());
        this.httpRequest = httpRequest;
        this.isIPCounted = false;
        this.isUploadCounted = false;
        this.sendAltLocSet = new HashSet();
        SocketFacade socket = connection.getSocket();
        this.hostAddress = socket.getRemoteAddress();
        this.uploadState = new UploadState(this.hostAddress, VendorCodes.UNKNOWN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startUpload() {
        NLogger.debug(UploadEngine.class, (Object)"Start upload.");
        this.uploadState.addToUploadLog("Start upload.");
        try {
            try {}
            catch (Exception exp) {
                this.uploadState.setStatus((short)4);
                NLogger.warn(UploadEngine.class, (Object)exp, (Throwable)exp);
                this.uploadState.addToUploadLog(exp.toString() + " - " + exp.getMessage());
                Object var4_8 = null;
                if (this.uploadState.getStatus() == 2 || this.uploadState.getStatus() == 0) {
                    NLogger.debug(UploadEngine.class, (Object)"Upload state should not be in init or up state anymore.");
                    NLogger.debug(UploadEngine.class, (Object)("Upload request: " + this.httpRequest.buildHTTPRequestString()));
                }
                this.stopUpload();
                UploadManager uploadMgr = UploadManager.getInstance();
                if (this.isIPCounted) {
                    uploadMgr.releaseUploadIP(this.hostAddress);
                }
                this.uploadState.setUploadEngine(null);
                if (!this.isUploadQueued) return;
                uploadMgr.removeQueuedUpload(this.uploadState);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            if (this.uploadState.getStatus() == 2 || this.uploadState.getStatus() == 0) {
                NLogger.debug(UploadEngine.class, (Object)"Upload state should not be in init or up state anymore.");
                NLogger.debug(UploadEngine.class, (Object)("Upload request: " + this.httpRequest.buildHTTPRequestString()));
            }
            this.stopUpload();
            UploadManager uploadMgr = UploadManager.getInstance();
            if (this.isIPCounted) {
                uploadMgr.releaseUploadIP(this.hostAddress);
            }
            this.uploadState.setUploadEngine(null);
            if (!this.isUploadQueued) throw throwable;
            uploadMgr.removeQueuedUpload(this.uploadState);
            throw throwable;
        }
        do {
            block23: {
                block22: {
                    try {
                        boolean accepted = this.evaluateHTTPRequest();
                        if (accepted) break block22;
                        this.uploadState.setStatus((short)4);
                    }
                    catch (IOException exp) {
                        this.uploadState.setStatus((short)4);
                        throw exp;
                    }
                    Object var4_6 = null;
                    if (this.uploadState.getStatus() == 2 || this.uploadState.getStatus() == 0) {
                        NLogger.debug(UploadEngine.class, (Object)"Upload state should not be in init or up state anymore.");
                        NLogger.debug(UploadEngine.class, (Object)("Upload request: " + this.httpRequest.buildHTTPRequestString()));
                    }
                    this.stopUpload();
                    UploadManager uploadMgr = UploadManager.getInstance();
                    if (this.isIPCounted) {
                        uploadMgr.releaseUploadIP(this.hostAddress);
                    }
                    this.uploadState.setUploadEngine(null);
                    if (!this.isUploadQueued) return;
                    uploadMgr.removeQueuedUpload(this.uploadState);
                    return;
                }
                if (this.httpRequest.isHeadRequest()) {
                    this.uploadState.setStatus((short)3);
                    break block23;
                }
                if (this.isUploadQueued) break block23;
                GnutellaRequest gRequest = this.httpRequest.getGnutellaRequest();
                if (gRequest.isTigerTreeRequest()) {
                    this.sendDIMEMessage(this.uploadShareFile);
                } else {
                    this.sendBinaryData();
                }
            }
            if (!this.isPersistentConnection) continue;
            try {
                this.readNextHTTPRequest();
            }
            catch (IOException exp) {
                NLogger.debug(class$phex$upload$UploadEngine == null ? UploadEngine.class$("phex.upload.UploadEngine") : class$phex$upload$UploadEngine, (Object)exp);
                this.uploadState.addToUploadLog(exp.toString() + " - " + exp.getMessage());
                this.isPersistentConnection = false;
            }
        } while (this.isPersistentConnection);
        Object var4_7 = null;
        if (this.uploadState.getStatus() == 2 || this.uploadState.getStatus() == 0) {
            NLogger.debug(UploadEngine.class, (Object)"Upload state should not be in init or up state anymore.");
            NLogger.debug(UploadEngine.class, (Object)("Upload request: " + this.httpRequest.buildHTTPRequestString()));
        }
        this.stopUpload();
        UploadManager uploadMgr = UploadManager.getInstance();
        if (this.isIPCounted) {
            uploadMgr.releaseUploadIP(this.hostAddress);
        }
        this.uploadState.setUploadEngine(null);
        if (!this.isUploadQueued) return;
        uploadMgr.removeQueuedUpload(this.uploadState);
    }

    public void stopUpload() {
        this.connection.disconnect();
        IOUtil.closeQuietly(this.raFile);
    }

    private void sendBinaryData() throws IOException {
        NLogger.debug(UploadEngine.class, (Object)("About to send binary range: " + this.startOffset + " to " + this.endOffset));
        this.uploadState.addToUploadLog("About to send binary range: " + this.startOffset + " to " + this.endOffset);
        if (!this.isUploadCounted) {
            this.uploadShareFile.incUploadCount();
            StatisticsManager statMgr = StatisticsManager.getInstance();
            SimpleStatisticProvider provider = (SimpleStatisticProvider)statMgr.getStatisticProvider("SessionUploadCountProvider");
            provider.increment(1);
            this.isUploadCounted = true;
        }
        this.uploadState.setStatus((short)2);
        File sourceFile = this.uploadState.getUploadFile();
        this.raFile = new RandomAccessFile(sourceFile, "r");
        this.raFile.seek(this.fileStartOffset);
        BandwidthController throttleController = BandwidthManager.getInstance().getUploadBandwidthController();
        long lengthUploaded = 0L;
        int lengthRead = -1;
        GnutellaOutputStream outStream = this.connection.getOutputStream();
        byte[] buffer = new byte[16384];
        for (long lengthToUpload = this.endOffset - this.startOffset + 1L; lengthToUpload > 0L; lengthToUpload -= (long)lengthRead) {
            int likeToSend = (int)Math.min(lengthToUpload, 16384L);
            int available = throttleController.getAvailableByteCount(true);
            int ableToSend = Math.min(likeToSend, available);
            if (NLogger.isDebugEnabled(class$phex$upload$UploadEngine == null ? UploadEngine.class$("phex.upload.UploadEngine") : class$phex$upload$UploadEngine)) {
                NLogger.debug(class$phex$upload$UploadEngine == null ? UploadEngine.class$("phex.upload.UploadEngine") : class$phex$upload$UploadEngine, (Object)("Reading in " + ableToSend + " bytes at " + this.raFile.getFilePointer() + " from " + sourceFile.getName()));
            }
            if ((lengthRead = this.raFile.read(buffer, 0, ableToSend)) == -1) break;
            ((OutputStream)outStream).write(buffer, 0, lengthRead);
            this.uploadState.setTransferredDataSize(lengthUploaded += (long)lengthRead);
        }
        this.uploadState.setStatus((short)3);
    }

    private boolean evaluateHTTPRequest() throws IOException {
        HTTPResponse httpResponse;
        ShareFile requestedShareFile;
        HTTPHeader header;
        String logMsg = "HTTP Request: " + this.httpRequest.buildHTTPRequestString();
        NLogger.debug(UploadEngine.class, (Object)logMsg);
        this.uploadState.addToUploadLog(logMsg);
        GnutellaRequest gRequest = this.httpRequest.getGnutellaRequest();
        if (gRequest == null) {
            throw new IOException("Not a Gnutella file request.");
        }
        if (gRequest.getURN() == null && (header = this.httpRequest.getHeader("X-Gnutella-Content-URN")) != null && URN.isValidURN(header.getValue())) {
            URN urn = new URN(header.getValue());
            gRequest.setContentURN(urn);
        }
        SocketFacade socket = this.connection.getSocket();
        int port = -1;
        header = this.httpRequest.getHeader("Listen-IP");
        if (header == null) {
            header = this.httpRequest.getHeader("X-My-Address");
        }
        if (header != null) {
            port = AddressUtils.parsePort(header.getValue());
        }
        if (port <= 0) {
            port = socket.getRemoteAddress().getPort();
        }
        this.hostAddress = new DefaultDestAddress(socket.getRemoteAddress().getHostName(), port);
        UploadManager uploadMgr = UploadManager.getInstance();
        if (!this.isIPCounted) {
            boolean succ = uploadMgr.validateAndCountIP(this.hostAddress);
            if (!succ) {
                HTTPResponse httpResponse2 = new HTTPResponse(503, "Upload Limit Reached for IP", true);
                this.sendHTTPResponse(httpResponse2);
                return false;
            }
            this.isIPCounted = true;
        }
        if ((requestedShareFile = this.findShareFile(gRequest)) == null) {
            HTTPResponse httpResponse3 = new HTTPResponse(404, "File not found", true);
            this.sendHTTPResponse(httpResponse3);
            return false;
        }
        this.isUploadQueued = false;
        if (uploadMgr.isHostBusy()) {
            header = this.httpRequest.getHeader("X-Queue");
            if (header == null || !ServiceManager.sCfg.allowUploadQueuing || uploadMgr.isQueueLimitReached()) {
                HTTPResponse httpResponse4 = new HTTPResponse(503, "Upload Limit Reached", true);
                this.addAltLocResponseHeader(httpResponse4, requestedShareFile);
                this.sendHTTPResponse(httpResponse4);
                return false;
            }
            this.isUploadQueued = true;
        }
        HTTPHeader rangeHeader = null;
        HTTPRangeSet uploadRange = null;
        Range uploadRangeEntry = null;
        if (!gRequest.isTigerTreeRequest()) {
            short rangeStatus;
            rangeHeader = this.httpRequest.getHeader("Range");
            if (rangeHeader != null) {
                uploadRange = HTTPRangeSet.parseHTTPRangeSet(rangeHeader.getValue(), true);
                if (uploadRange == null) {
                    HTTPResponse httpResponse5 = new HTTPResponse(500, "Requested Range Not Parseable", true);
                    this.addAltLocResponseHeader(httpResponse5, requestedShareFile);
                    this.sendHTTPResponse(httpResponse5);
                    return false;
                }
            } else {
                uploadRange = new HTTPRangeSet(0L, -1L);
            }
            if ((rangeStatus = requestedShareFile.getRangeAvailableStatus(uploadRangeEntry = uploadRange.getFirstRange())) != 0) {
                HTTPResponse httpResponse6 = rangeStatus == 1 ? new HTTPResponse(503, "Requested Range Not Available", true) : new HTTPResponse(416, "Requested Range Not Satisfiable", true);
                if (requestedShareFile instanceof PartialShareFile) {
                    PartialShareFile pShareFile = (PartialShareFile)requestedShareFile;
                    httpResponse6.addHeader(new HTTPHeader("X-Available-Ranges", pShareFile.buildXAvailableRangesString()));
                }
                this.addAltLocResponseHeader(httpResponse6, requestedShareFile);
                this.sendHTTPResponse(httpResponse6);
                return false;
            }
        }
        String vendor = null;
        header = this.httpRequest.getHeader("User-Agent");
        vendor = header != null ? header.getValue() : "";
        header = this.httpRequest.getHeader("Connection");
        this.isPersistentConnection = "HTTP/1.1".equals(this.httpRequest.getHTTPVersion()) ? header == null || !header.getValue().equalsIgnoreCase("CLOSE") : header != null && header.getValue().equalsIgnoreCase("KEEP-ALIVE");
        if (this.isUploadQueued) {
            this.uploadState.update(this.hostAddress, vendor);
            int queuePosition = uploadMgr.getQueuedPosition(this.uploadState) + 1;
            if (queuePosition < 0) {
                queuePosition = uploadMgr.addQueuedUpload(this.uploadState) + 1;
            }
            this.uploadState.setStatus((short)1);
            int queueLength = uploadMgr.getUploadQueueSize();
            int uploadLimit = ServiceManager.sCfg.mMaxUpload;
            int pollMin = ServiceManager.sCfg.minUploadQueuePollTime;
            int pollMax = ServiceManager.sCfg.maxUploadQueuePollTime;
            HTTPResponse httpResponse7 = new HTTPResponse(503, "Remotely Queued", true);
            this.addAltLocResponseHeader(httpResponse7, requestedShareFile);
            XQueueParameters xQueueParas = new XQueueParameters(queuePosition, queueLength, uploadLimit, pollMin, pollMax);
            httpResponse7.addHeader(new HTTPHeader("X-Queue", xQueueParas.buildHTTPString()));
            this.sendHTTPResponse(httpResponse7);
            socket.setSoTimeout(pollMax * 1000);
            this.minNextPollTime = System.currentTimeMillis() + (long)(pollMin * 1000);
            return true;
        }
        HTTPHeader additionalResponseHeader = null;
        long contentLength = 0L;
        if (!gRequest.isTigerTreeRequest()) {
            if (requestedShareFile instanceof PartialShareFile) {
                PartialShareFile pShareFile = (PartialShareFile)requestedShareFile;
                pShareFile.findFittingPartForRange(uploadRangeEntry);
                this.fileStartOffset = pShareFile.getFileStartOffset();
                additionalResponseHeader = new HTTPHeader("X-Available-Ranges", pShareFile.buildXAvailableRangesString());
            } else {
                this.fileStartOffset = uploadRangeEntry.getStartOffset(requestedShareFile.getFileSize());
            }
            this.startOffset = uploadRangeEntry.getStartOffset(requestedShareFile.getFileSize());
            this.endOffset = uploadRangeEntry.getEndOffset(requestedShareFile.getFileSize());
            contentLength = this.endOffset - this.startOffset + 1L;
        }
        URN sharedFileURN = requestedShareFile.getURN();
        if (gRequest.isTigerTreeRequest()) {
            this.uploadState.update(this.hostAddress, vendor, requestedShareFile.getFileName());
        } else {
            this.uploadState.update(this.hostAddress, vendor, requestedShareFile.getFileName(), sharedFileURN, requestedShareFile.getSystemFile(), contentLength);
        }
        if (!uploadMgr.containsUploadState(this.uploadState)) {
            uploadMgr.addUploadState(this.uploadState);
        }
        this.uploadState.setUploadEngine(this);
        if (!gRequest.isTigerTreeRequest()) {
            httpResponse = this.startOffset == 0L && this.endOffset == requestedShareFile.getFileSize() - 1L ? new HTTPResponse(200, "OK", true) : new HTTPResponse(206, "Partial Content", true);
            if (additionalResponseHeader != null) {
                httpResponse.addHeader(additionalResponseHeader);
            }
        } else {
            httpResponse = new HTTPResponse(200, "OK", true);
        }
        httpResponse.addHeader(new HTTPHeader("Content-Type", "application/binary"));
        if (!gRequest.isTigerTreeRequest()) {
            httpResponse.addHeader(new HTTPHeader("Content-Length", String.valueOf(contentLength)));
            httpResponse.addHeader(new HTTPHeader("Content-Range", "bytes " + this.startOffset + "-" + this.endOffset + "/" + requestedShareFile.getFileSize()));
        }
        if (this.isPersistentConnection && !gRequest.isTigerTreeRequest()) {
            httpResponse.addHeader(new HTTPHeader("Connection", "Keep-Alive"));
        } else {
            httpResponse.addHeader(new HTTPHeader("Connection", "close"));
            this.isPersistentConnection = false;
        }
        if (sharedFileURN != null) {
            httpResponse.addHeader(new HTTPHeader("X-Gnutella-Content-URN", sharedFileURN.getAsString()));
        }
        if (!gRequest.isTigerTreeRequest()) {
            this.addAltLocResponseHeader(httpResponse, requestedShareFile);
            this.addPushProxyResponseHeader(httpResponse);
        }
        if (sharedFileURN != null && !gRequest.isTigerTreeRequest()) {
            this.parseAltLocRequestHeader(requestedShareFile, sharedFileURN);
            ShareFileThexData thexData = requestedShareFile.getThexData(true);
            if (thexData != null) {
                String thexRootHash = thexData.getRootHash();
                HTTPHeader thexHeader = new HTTPHeader("X-Thex-URI", URLUtil.buildName2ResThexURL(sharedFileURN, thexRootHash));
                httpResponse.addHeader(thexHeader);
            }
        }
        this.sendHTTPResponse(httpResponse);
        socket.setSoTimeout(ServiceManager.sCfg.socketConnectTimeout);
        if (this.uploadShareFile != null && !(requestedShareFile instanceof PartialShareFile) && this.uploadShareFile != requestedShareFile) {
            this.isUploadCounted = false;
        }
        this.uploadShareFile = requestedShareFile;
        this.minNextPollTime = -1L;
        return true;
    }

    private void parseAltLocRequestHeader(ShareFile requestedShareFile, URN sharedFileURN) {
        AltLocContainer altLocContainer = requestedShareFile.getAltLocContainer();
        ArrayList allAltLocs = new ArrayList();
        HTTPHeader[] headers = this.httpRequest.getHeaders("Alt-Location");
        List altLocList = AltLocContainer.parseUriResAltLocFromHeaders(headers);
        allAltLocs.addAll(altLocList);
        headers = this.httpRequest.getHeaders("X-Gnutella-Alternate-Location");
        altLocList = AltLocContainer.parseUriResAltLocFromHeaders(headers);
        allAltLocs.addAll(altLocList);
        headers = this.httpRequest.getHeaders("X-Alt");
        altLocList = AltLocContainer.parseCompactIpAltLocFromHeaders(headers, sharedFileURN);
        allAltLocs.addAll(altLocList);
        Iterator iterator = allAltLocs.iterator();
        while (iterator.hasNext()) {
            AlternateLocation altLoc = (AlternateLocation)iterator.next();
            String logMsg = "Adding AltLoc " + altLoc.getHTTPString();
            NLogger.debug(class$phex$upload$UploadEngine == null ? UploadEngine.class$("phex.upload.UploadEngine") : class$phex$upload$UploadEngine, (Object)logMsg);
            this.uploadState.addToUploadLog(logMsg);
            altLocContainer.addAlternateLocation(altLoc);
        }
    }

    private void addAltLocResponseHeader(HTTPResponse httpResponse, ShareFile shareFile) {
        AltLocContainer altLocContainer = shareFile.getAltLocContainer();
        HTTPHeader header = altLocContainer.getAltLocHTTPHeaderForAddress("X-Alt", this.hostAddress, this.sendAltLocSet);
        if (header != null) {
            httpResponse.addHeader(header);
        }
    }

    private void addPushProxyResponseHeader(HTTPResponse httpResponse) {
        HostManager hostManager = HostManager.getInstance();
        NetworkHostsContainer networkHostsContainer = hostManager.getNetworkHostsContainer();
        DestAddress[] pushProxyAddresses = networkHostsContainer.getPushProxies();
        if (pushProxyAddresses == null) {
            return;
        }
        StringBuffer headerValue = new StringBuffer();
        int count = Math.min(4, pushProxyAddresses.length);
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                headerValue.append(",");
            }
            headerValue.append(pushProxyAddresses[i].getFullHostName());
        }
        if (headerValue.length() > 0) {
            HTTPHeader header = new HTTPHeader("X-Push-Proxy", headerValue.toString());
            httpResponse.addHeader(header);
        }
    }

    private void readNextHTTPRequest() throws IOException {
        try {
            this.httpRequest = HTTPProcessor.parseHTTPRequest(this.connection);
            if (this.minNextPollTime > 0L && System.currentTimeMillis() < this.minNextPollTime) {
                throw new IOException("Queued host is requesting too soon.");
            }
        }
        catch (HTTPMessageException exp) {
            throw new IOException("Invalid HTTP Message: " + exp.getMessage());
        }
    }

    private void sendHTTPResponse(HTTPResponse httpResponse) throws IOException {
        String httpResponseStr = httpResponse.buildHTTPResponseString();
        String logMsg = "HTTP Response: " + httpResponseStr;
        NLogger.debug(UploadEngine.class, (Object)logMsg);
        this.uploadState.addToUploadLog(logMsg);
        this.connection.write(httpResponseStr.getBytes());
    }

    private ShareFile findShareFile(GnutellaRequest gRequest) {
        ShareFile shareFile = null;
        SharedFilesService sharedFilesService = ShareManager.getInstance().getSharedFilesService();
        URN requestURN = gRequest.getURN();
        if (requestURN != null) {
            SwarmingManager swMgr;
            SWDownloadFile dwFile;
            if (!requestURN.isSha1Nid()) {
                requestURN = new URN("urn:sha1:" + requestURN.getSHA1Nss());
            }
            if ((shareFile = sharedFilesService.getFileByURN(requestURN)) == null && ServiceManager.sCfg.arePartialFilesShared && (dwFile = (swMgr = SwarmingManager.getInstance()).getDownloadFileByURN(requestURN)) != null) {
                shareFile = new PartialShareFile(dwFile);
            }
        } else if (gRequest.getFileIndex() != -1) {
            int index = gRequest.getFileIndex();
            shareFile = sharedFilesService.getFileByIndex(index);
            if (shareFile != null) {
                String shareFileName = shareFile.getFileName();
                if (!gRequest.getFileName().equalsIgnoreCase(shareFileName)) {
                    String logMsg = "Requested index '" + index + "' with filename '" + shareFileName + "' dosn't match request filename '" + gRequest.getFileName() + "'.";
                    NLogger.debug(UploadEngine.class, (Object)logMsg);
                    this.uploadState.addToUploadLog(logMsg);
                    shareFile = null;
                }
            } else if (gRequest.getFileName() != null) {
                shareFile = sharedFilesService.getFileByName(gRequest.getFileName());
            }
        }
        return shareFile;
    }

    private void sendDIMEMessage(ShareFile shareFile) throws IOException {
        this.uploadState.setStatus((short)2);
        ShareFileThexData thexData = shareFile.getThexData(true);
        String uuidStr = StringUtils.generateRandomUUIDString();
        ThexHashTree hashTree = new ThexHashTree();
        hashTree.setFileSize(String.valueOf(shareFile.getFileSize()));
        hashTree.setFileSegmentSize("1024");
        hashTree.setDigestAlgorithm("http://open-content.net/spec/digest/tiger");
        hashTree.setDigestOutputSize("24");
        hashTree.setSerializedTreeDepth(String.valueOf(thexData.getTreeDepth()));
        hashTree.setSerializedTreeType("http://open-content.net/spec/thex/breadthfirst");
        hashTree.setSerializedTreeUri("uuid:" + uuidStr);
        String type = "http://open-content.net/spec/thex/breadthfirst";
        byte[] metadata = ThexHashTreeCodec.generateThexHashTreeXML(hashTree);
        byte[] serialization = thexData.getSerializedTreeNodes();
        DimeGenerator dg = new DimeGenerator(this.connection.getOutputStream());
        DimeRecord dr = new DimeRecord(metadata, DimeRecord.TypeNameFormat.MEDIA_TYPE, type, null);
        dg.addRecord(dr, false);
        DimeRecord dr2 = new DimeRecord(serialization, DimeRecord.TypeNameFormat.URI, type, null);
        dg.addRecord(dr2, true);
        this.connection.flush();
        this.uploadState.setStatus((short)3);
    }
}

