/*
 * Decompiled with CFR 0.152.
 */
package phex.upload;

import java.io.File;
import phex.common.ServiceManager;
import phex.common.TransferDataProvider;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.common.bandwidth.TransferAverage;
import phex.common.log.LogRecord;
import phex.upload.UploadConstants;
import phex.upload.UploadEngine;
import phex.upload.UploadManager;
import phex.utils.Logger;

public class UploadState
implements TransferDataProvider,
UploadConstants {
    private UploadManager uploadManager = UploadManager.getInstance();
    private long transferredDataSize = 0L;
    private Integer currentProgress = new Integer(0);
    private short status;
    private DestAddress hostAddress;
    private String vendor;
    private String fileName;
    private URN fileURN;
    private File uploadFile;
    private UploadEngine uploadEngine;
    private long previousSegmentsSize = 0L;
    private TransferAverage transferAverage;
    private long transferLength;

    public UploadState(DestAddress hostAddress, String vendor) {
        this(hostAddress, vendor, null, null, null, -1L);
    }

    public UploadState(DestAddress hostAddress, String vendor, String fileName, URN fileURN, File uploadFile, long contentLength) {
        this.hostAddress = hostAddress;
        this.vendor = vendor;
        this.fileName = fileName;
        this.fileURN = fileURN;
        this.uploadFile = uploadFile;
        this.transferLength = contentLength;
        this.status = 0;
        this.transferAverage = new TransferAverage(1000, 10);
    }

    public void update(DestAddress hostAddress, String vendor) {
        this.hostAddress = hostAddress;
        this.vendor = vendor;
    }

    public void update(DestAddress hostAddress, String vendor, String fileName) {
        this.hostAddress = hostAddress;
        this.vendor = vendor;
        this.fileName = fileName;
    }

    public void update(DestAddress hostAddress, String vendor, String fileName, URN fileURN, File uploadFile, long contentLength) {
        this.hostAddress = hostAddress;
        this.vendor = vendor;
        this.fileName = fileName;
        this.fileURN = fileURN;
        this.uploadFile = uploadFile;
        this.transferLength = contentLength;
    }

    public File getUploadFile() {
        return this.uploadFile;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getFileName() {
        return this.fileName;
    }

    public URN getFileURN() {
        return this.fileURN;
    }

    public DestAddress getHostAddress() {
        return this.hostAddress;
    }

    public short getStatus() {
        return this.status;
    }

    public void addToUploadLog(String message) {
        if (ServiceManager.sCfg.uploadStateLogBufferSize > 0L) {
            LogRecord record = new LogRecord(this, message);
            UploadManager.getInstance().getUploadStateLogBuffer().addLogRecord(record);
        }
    }

    public void setStatus(short newStatus) {
        if (this.status == newStatus) {
            return;
        }
        Logger.logMessage(Logger.FINE, (short)4, "UploadState Status " + newStatus);
        switch (newStatus) {
            case 3: 
            case 4: {
                this.uploadStopNotify();
                break;
            }
            case 2: {
                this.uploadStartNotify();
            }
        }
        this.status = newStatus;
        this.uploadManager.fireUploadFileChanged(this);
    }

    private void uploadStartNotify() {
    }

    private void uploadStopNotify() {
    }

    public boolean isUploadRunning() {
        return this.status == 2;
    }

    public void setUploadEngine(UploadEngine uploadEngine) {
        this.uploadEngine = uploadEngine;
    }

    public void setTransferredDataSize(long aTransferredSize) {
        long diff = aTransferredSize - this.transferredDataSize;
        if (diff < 0L) {
            this.previousSegmentsSize += this.transferredDataSize;
            this.transferAverage.addValue(aTransferredSize);
        } else {
            this.transferAverage.addValue(diff);
        }
        this.transferredDataSize = aTransferredSize;
        this.uploadManager.fireUploadFileChanged(this);
    }

    public Integer getProgress() {
        int percentage;
        if (this.status == 3) {
            percentage = 100;
        } else {
            long toTransfer = this.getTransferDataSize();
            percentage = (int)(this.getTransferredDataSize() * 100L / (toTransfer == 0L ? 1L : toTransfer));
        }
        if (this.currentProgress != percentage) {
            this.currentProgress = new Integer(percentage);
        }
        return this.currentProgress;
    }

    public void stopUpload() {
        if (this.uploadEngine != null) {
            this.uploadEngine.stopUpload();
        }
        this.setStatus((short)4);
    }

    public long getTransferSpeed() {
        return this.transferAverage.getAverage();
    }

    public long getTransferDataSize() {
        return this.transferLength + this.previousSegmentsSize;
    }

    public long getTransferredDataSize() {
        return this.transferredDataSize + this.previousSegmentsSize;
    }

    public long getTotalDataSize() {
        return this.getTransferDataSize();
    }

    public void setTransferRateTimestamp(long timestamp) {
        throw new UnsupportedOperationException();
    }

    public int getShortTermTransferRate() {
        throw new UnsupportedOperationException();
    }

    public int getLongTermTransferRate() {
        return (int)this.getTransferSpeed();
    }

    public short getDataTransferStatus() {
        switch (this.status) {
            case 2: {
                return 10;
            }
            case 4: {
                return 13;
            }
            case 3: {
                return 12;
            }
        }
        return 11;
    }
}

