/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.IOException;
import java.io.InputStream;
import phex.common.bandwidth.BandwidthController;
import phex.utils.NLogger;

public class BandwidthInputStream
extends InputStream {
    private InputStream inStream;
    private BandwidthController bandwidthController;

    public BandwidthInputStream(InputStream aInputStream, BandwidthController aBandwidthController) {
        this.inStream = aInputStream;
        this.bandwidthController = aBandwidthController;
    }

    public void setBandwidthController(BandwidthController bandwidthController) {
        this.bandwidthController = bandwidthController;
    }

    public int read() throws IOException {
        this.bandwidthController.getAvailableByteCount(true);
        int val = this.inStream.read();
        this.bandwidthController.markBytesUsed(1);
        return val;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int available = this.bandwidthController.getAvailableByteCount(len, true);
        try {
            int readLen = this.inStream.read(b, off, available);
            this.bandwidthController.markBytesUsed(readLen);
            return readLen;
        }
        catch (ArrayIndexOutOfBoundsException exp) {
            NLogger.error("BANDWIDTH", (Object)exp, (Throwable)exp);
            NLogger.error("BANDWIDTH", "buffer:" + b.length + " off " + off + " len " + len + " avail " + available);
            return 0;
        }
    }

    public int available() throws IOException {
        return this.inStream.available();
    }

    public void close() throws IOException {
        this.inStream.close();
    }
}

