/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import phex.common.IntObj;
import phex.host.Host;
import phex.msg.GUID;

public class GUIDRoutingTable {
    private static final int MAX_ROUTE_TABLE_SIZE = 50000;
    protected Map currentMap;
    protected Map lastMap;
    protected Map idToHostMap;
    protected Map hostToIdMap;
    private long lifetime;
    private long nextReplaceTime;
    private int nextId;

    public GUIDRoutingTable(long lifetime) {
        this.lifetime = lifetime;
        this.nextId = 0;
        this.currentMap = new TreeMap(new GUID.GUIDComparator());
        this.lastMap = new TreeMap(new GUID.GUIDComparator());
        this.idToHostMap = new HashMap();
        this.hostToIdMap = new HashMap();
    }

    public synchronized void addRouting(GUID guid, Host host) {
        this.checkForSwitch();
        if (!host.isConnected()) {
            return;
        }
        IntObj id = this.getIdForHost(host);
        Entry entry = (Entry)this.currentMap.remove(guid);
        if (entry == null && (entry = (Entry)this.lastMap.remove(guid)) == null) {
            entry = this.createNewEntry();
        }
        entry.hostId = id;
        this.currentMap.put(guid, entry);
    }

    public synchronized boolean checkAndAddRouting(GUID guid, Host host) {
        this.checkForSwitch();
        if (!host.isConnected()) {
            return false;
        }
        if (!this.currentMap.containsKey(guid) && !this.lastMap.containsKey(guid)) {
            IntObj id = this.getIdForHost(host);
            Entry entry = this.createNewEntry();
            entry.hostId = id;
            this.currentMap.put(guid, entry);
            return true;
        }
        return false;
    }

    public synchronized void removeHost(Host host) {
        IntObj id = (IntObj)this.hostToIdMap.get(host);
        if (id != null) {
            this.idToHostMap.remove(id);
            this.hostToIdMap.remove(host);
        }
    }

    public synchronized Host findRouting(GUID guid) {
        Entry entry = (Entry)this.currentMap.get(guid);
        if (entry == null) {
            entry = (Entry)this.lastMap.get(guid);
        }
        if (entry != null) {
            return (Host)this.idToHostMap.get(entry.hostId);
        }
        return null;
    }

    protected void checkForSwitch() {
        long currentTime = System.currentTimeMillis();
        if (currentTime < this.nextReplaceTime && this.currentMap.size() < 50000) {
            return;
        }
        this.lastMap.clear();
        Map temp = this.lastMap;
        this.lastMap = this.currentMap;
        this.currentMap = temp;
        this.nextReplaceTime = currentTime + this.lifetime;
    }

    protected IntObj getIdForHost(Host host) {
        IntObj id = (IntObj)this.hostToIdMap.get(host);
        if (id != null) {
            return id;
        }
        id = new IntObj(this.nextId++);
        while (this.idToHostMap.get(id) != null) {
            id.setValue(this.nextId++);
        }
        this.idToHostMap.put(id, host);
        this.hostToIdMap.put(host, id);
        return id;
    }

    protected Entry createNewEntry() {
        return new Entry();
    }

    protected static class Entry {
        protected IntObj hostId;

        protected Entry() {
        }
    }
}

