/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.URI;
import phex.common.URN;
import phex.download.MagnetData;
import phex.download.swarming.SwarmingManager;
import phex.utils.MagmaParser;
import phex.utils.NLogger;

public final class InternalFileHandler {
    public static void magmaReadout(File file) {
        try {
            BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(file));
            MagmaParser parser = new MagmaParser(inStream);
            parser.start();
            List magnetList = parser.getMagnets();
            Iterator iter = magnetList.iterator();
            while (iter.hasNext()) {
                String magnet = (String)iter.next();
                URI uri = new URI(magnet, true);
                MagnetData magnetData = MagnetData.parseFromURI(uri);
                URN urn = MagnetData.lookupSHA1URN(magnetData);
                SwarmingManager swarmingMgr = SwarmingManager.getInstance();
                if (swarmingMgr.isURNDownloaded(urn)) continue;
                swarmingMgr.addFileToDownload(uri);
            }
        }
        catch (IOException exp) {
            NLogger.warn("MAGMA", (Object)exp.getMessage(), (Throwable)exp);
        }
    }

    public static void sheduledReadout(URI uri, long time) {
        try {
            MagnetData magnetData = MagnetData.parseFromURI(uri);
            URN urn = MagnetData.lookupSHA1URN(magnetData);
            SwarmingManager swarmingMgr = SwarmingManager.getInstance();
            if (!swarmingMgr.isURNDownloaded(urn)) {
                swarmingMgr.addFileToDownload(uri);
            }
        }
        catch (IOException exp) {
            NLogger.warn("MAGMA", (Object)exp.getMessage(), (Throwable)exp);
        }
    }
}

