/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MagmaParser {
    public String uuri;
    private static final String EOL_CHARACTERS = "\r\n";
    private static final char[] MAGMA_LINE;
    private static final char[] MAGNET_PREFIX;
    private static final char[] LIST_ELEMENT;
    private PushbackReader reader;
    private ArrayList magnets;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MagmaParser(InputStream inStream) {
        block2: {
            this.magnets = new ArrayList();
            try {
                InputStreamReader reader = new InputStreamReader(inStream, "UTF-8");
                this.reader = new PushbackReader(reader, 6);
            }
            catch (UnsupportedEncodingException exp) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        try {
            int count;
            char[] buff = new char[6];
            for (int readBytes = 0; readBytes != 6; readBytes += count) {
                count = this.reader.read(buff, readBytes, 6);
                if (count != -1) continue;
                throw new IOException("Input file is no MAGMA-File (" + String.valueOf(buff) + ").");
            }
            if (Arrays.equals(buff, MAGMA_LINE)) {
                this.skipToEOL();
                this.parseList();
            }
        }
        finally {
            this.reader.close();
        }
    }

    public List getMagnets() {
        return this.magnets;
    }

    private void parseList() throws IOException {
        int pos = 0;
        while (true) {
            int c;
            if ((c = this.reader.read()) == LIST_ELEMENT[pos]) {
                if (++pos != LIST_ELEMENT.length) continue;
                this.skipToEOL();
                this.parseListBody();
                pos = 0;
                continue;
            }
            if (c == -1) {
                return;
            }
            pos = 0;
            this.skipToEOL();
        }
    }

    private void parseListBody() throws IOException {
        boolean startOfLine = true;
        while (true) {
            int c;
            if ((c = this.reader.read()) == 45) {
                if (!startOfLine) {
                    this.parseListElement();
                    continue;
                }
                int pre = this.reader.read();
                if (pre == 32) {
                    this.reader.unread(pre);
                    this.parseListElement();
                    continue;
                }
                this.reader.unread(pre);
                this.reader.unread(c);
                return;
            }
            if (c == 35) {
                this.skipToEOL();
                startOfLine = true;
                continue;
            }
            if (c == 32 || c == 13 || c == 10) {
                startOfLine = false;
                continue;
            }
            if (EOL_CHARACTERS.indexOf(c) != -1) {
                startOfLine = true;
                continue;
            }
            if (c == -1) {
                return;
            }
            if (startOfLine) {
                this.reader.unread(c);
                return;
            }
            this.skipToEOL();
            startOfLine = true;
        }
    }

    private void parseListElement() throws IOException {
        int c;
        while (true) {
            if ((c = this.reader.read()) == 32) {
                continue;
            }
            if (c != 35) break;
            this.skipToEOL();
        }
        if (c == 34) {
            int count;
            char[] buff = new char[6];
            for (int readBytes = 0; readBytes != 6; readBytes += count) {
                count = this.reader.read(buff, readBytes, 6);
                if (count != -1) continue;
                return;
            }
            this.reader.unread(buff);
            if (Arrays.equals(buff, MAGNET_PREFIX)) {
                this.parseMagnet();
            } else {
                this.skipToEOL();
            }
            return;
        }
        if (c == -1) {
            return;
        }
        this.skipToEOL();
    }

    private void parseMagnet() throws IOException {
        StringBuffer magnetBuf = new StringBuffer();
        while (true) {
            int c;
            if ((c = this.reader.read()) == 32 || EOL_CHARACTERS.indexOf(c) != -1) {
                continue;
            }
            if (c == 34) break;
            if (c == -1) {
                return;
            }
            magnetBuf.append((char)c);
        }
        this.magnets.add(magnetBuf.toString());
    }

    private void skipToEOL() throws IOException {
        int c;
        do {
            if ((c = this.reader.read()) >= 0) continue;
            return;
        } while (EOL_CHARACTERS.indexOf(c) == -1);
        while (EOL_CHARACTERS.indexOf(c) != -1) {
            c = this.reader.read();
        }
        this.reader.unread(c);
    }

    static {
        $assertionsDisabled = !MagmaParser.class.desiredAssertionStatus();
        MAGMA_LINE = new char[]{'#', 'M', 'A', 'G', 'M', 'A'};
        MAGNET_PREFIX = new char[]{'m', 'a', 'g', 'n', 'e', 't'};
        LIST_ELEMENT = new char[]{'l', 'i', 's', 't', ':'};
    }
}

