/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import phex.utils.CircularQueue;
import phex.utils.CompoundIterator;

public class PriorityQueue {
    private CircularQueue[] queues;
    private int size;

    public PriorityQueue(int[] capacities) {
        this.queues = new CircularQueue[capacities.length];
        for (int i = 0; i < capacities.length; ++i) {
            this.queues[i] = new CircularQueue((int)Math.ceil((double)capacities[i] / 4.0), capacities[i]);
        }
    }

    public Object addToHead(Object obj, int priority) {
        if (priority < 0 || priority >= this.queues.length) {
            throw new IllegalArgumentException("Priority out of range: " + priority);
        }
        Object dropObj = this.queues[priority].addToHead(obj);
        if (dropObj == null) {
            ++this.size;
        }
        return dropObj;
    }

    public Object removeMaxPriority() throws NoSuchElementException {
        for (int i = this.queues.length - 1; i >= 0; --i) {
            if (this.queues[i].isEmpty()) continue;
            --this.size;
            return this.queues[i].removeFromHead();
        }
        throw new NoSuchElementException("PriorityQueue is empty");
    }

    public Object[] remove() throws NoSuchElementException {
        for (int i = this.queues.length - 1; i >= 0; --i) {
            if (this.queues[i].isEmpty()) continue;
            --this.size;
            Object[] elementAndPriotity = new Object[]{this.queues[i].removeFromHead(), new Integer(i)};
            return elementAndPriotity;
        }
        throw new NoSuchElementException("PriorityQueue is empty");
    }

    public boolean removeFromAll(Object obj) {
        int i;
        boolean removed = false;
        for (i = 0; i < this.queues.length; ++i) {
            removed |= this.queues[i].removeAll(obj);
        }
        if (removed) {
            this.size = 0;
            for (i = 0; i < this.queues.length; ++i) {
                this.size += this.queues[i].getSize();
            }
        }
        return removed;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull(int priority) {
        return this.queues[priority].isFull();
    }

    public void clear() {
        for (int i = 0; i < this.queues.length; ++i) {
            this.queues[i].clear();
        }
        this.size = 0;
    }

    public Iterator iterator() {
        CompoundIterator iterator = new CompoundIterator(this.queues.length);
        for (int i = this.queues.length - 1; i >= 0; --i) {
            if (this.queues[i].getSize() <= 0) continue;
            iterator.addIterator(this.queues[i].iterator());
        }
        return iterator;
    }
}

