/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.text.NumberFormat;
import java.util.Random;
import java.util.StringTokenizer;
import phex.common.Cfg;

public final class StringUtils {
    public static final String FILE_DELIMITERS = " -._+/*()[]\\";
    public static NumberFormat FILE_LENGTH_FORMAT = NumberFormat.getInstance();
    private static Random randomizer = new Random();
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static boolean isEmpty(String val) {
        return val == null || val.length() == 0;
    }

    public static String createNaturalSearchTerm(String searchTerm) {
        StringTokenizer tokenizer = new StringTokenizer(searchTerm, ",-._()[]");
        int tokenCount = tokenizer.countTokens();
        if (tokenCount == 0) {
            return searchTerm;
        }
        StringBuffer searchTermBuffer = new StringBuffer(searchTerm.length());
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.length() < Cfg.MIN_SEARCH_TERM_LENGTH) continue;
            searchTermBuffer.append(token);
            searchTermBuffer.append(' ');
        }
        return searchTermBuffer.toString();
    }

    public static String join(Object[] array, String separator) {
        int arraySize;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        int bufSize = (arraySize = array.length) == 0 ? 0 : arraySize * ((array[0] == null ? 16 : array[0].toString().length()) + separator.length());
        StringBuffer buf = new StringBuffer(bufSize);
        for (int i = 0; i < arraySize; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String replace(String text, String repl, String with, int max) {
        if (StringUtils.isEmpty(text) || StringUtils.isEmpty(repl) || with == null || max == 0) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(repl, start);
        if (end == -1) {
            return text;
        }
        int increase = with.length() - repl.length();
        int n = increase = increase < 0 ? 0 : increase;
        StringBuffer buf = new StringBuffer(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
            if (--max == 0) break;
            end = text.indexOf(repl, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static String generateRandomUUIDString() {
        byte[] uuid = new byte[16];
        randomizer.nextBytes(uuid);
        uuid[6] = (byte)(uuid[6] & 0xF);
        uuid[6] = (byte)(uuid[6] | 0x40);
        uuid[8] = (byte)(uuid[8] & 0x3F);
        uuid[8] = (byte)(uuid[8] | 0xFFFFFF80);
        StringBuffer buf = new StringBuffer(36);
        for (int i = 0; i < 16; ++i) {
            int val = uuid[i] & 0xFF;
            buf.append(HEX_CHARS[val >> 4]);
            buf.append(HEX_CHARS[val & 0xF]);
        }
        buf.insert(8, '-');
        buf.insert(13, '-');
        buf.insert(18, '-');
        buf.insert(23, '-');
        return buf.toString();
    }
}

