/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.SystemUtils;
import phex.common.MediaType;
import phex.common.ServiceManager;
import phex.utils.NLogger;
import phex.utils.StringUtils;
import phex.utils.WindowsShellExecute;

public class SystemShellExecute {
    public static void exploreFolder(File dir) throws IOException {
        String path;
        try {
            path = dir.getCanonicalPath();
        }
        catch (IOException ioe) {
            path = dir.getPath();
        }
        String command = null;
        if (SystemUtils.IS_OS_WINDOWS) {
            command = "explorer";
        } else if (SystemUtils.IS_OS_MAC_OSX) {
            command = "open";
        }
        if (command == null) {
            return;
        }
        String[] cmdArr = new String[]{command, path};
        Runtime.getRuntime().exec(cmdArr);
    }

    public static void launchFile(File file) throws IOException {
        String path;
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException ioe) {
            path = file.getPath();
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            WindowsShellExecute.executeViaShell(path);
            return;
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            String command = "open";
            String[] cmdArr = new String[]{command, path};
            Runtime.getRuntime().exec(cmdArr);
            return;
        }
        SystemShellExecute.launchOtherOsFile(path);
    }

    private static void launchOtherOsFile(String filepath) throws IOException {
        String commandStr = MediaType.getVideoMediaType().isFilenameOf(filepath) ? ServiceManager.sCfg.otherOsVideoCommand : (MediaType.getImageMediaType().isFilenameOf(filepath) ? ServiceManager.sCfg.otherOsImageCommand : (MediaType.getAudioMediaType().isFilenameOf(filepath) ? ServiceManager.sCfg.otherOsAudioCommand : ServiceManager.sCfg.otherOsBrowserCommand));
        Pattern p = Pattern.compile("(\".*?\"|\\S+)", 2);
        Matcher m = p.matcher(commandStr);
        LinkedList<String> tokens = new LinkedList<String>();
        while (m.find()) {
            tokens.add(m.group(1));
        }
        String[] result = new String[tokens.size()];
        tokens.toArray(result);
        StringBuffer replacedCmd = new StringBuffer();
        for (int i = 0; i < result.length; ++i) {
            result[i] = StringUtils.replace(result[i], "%filepath%", filepath, -1);
            replacedCmd.append(result[i]);
            replacedCmd.append(" ");
        }
        NLogger.debug(SystemShellExecute.class, (Object)("Executing " + replacedCmd));
        Runtime.getRuntime().exec(result);
    }
}

