/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.impl.runtime;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import phex.xml.impl.runtime.GrammarInfo;
import phex.xml.impl.runtime.UnmarshallableObject;
import phex.xml.impl.runtime.UnmarshallingContext;
import phex.xml.impl.runtime.UnmarshallingEventHandler;
import phex.xml.impl.runtime.XMLSerializable;

public class GrammarInfoImpl
implements GrammarInfo {
    private final Map rootTagMap;
    private final Class objectFactoryClass;
    private final Map defaultImplementationMap;
    private final ClassLoader classLoader;

    public GrammarInfoImpl(Map _rootTagMap, Map _defaultImplementationMap, Class _objectFactoryClass) {
        this.rootTagMap = _rootTagMap;
        this.defaultImplementationMap = _defaultImplementationMap;
        this.objectFactoryClass = _objectFactoryClass;
        this.classLoader = this.objectFactoryClass.getClassLoader();
    }

    private final Class lookupRootMap(String nsUri, String localName) {
        QName qn = new QName(nsUri, localName);
        if (this.rootTagMap.containsKey(qn)) {
            return (Class)this.rootTagMap.get(qn);
        }
        qn = new QName(nsUri, "*");
        if (this.rootTagMap.containsKey(qn)) {
            return (Class)this.rootTagMap.get(qn);
        }
        qn = new QName("*", "*");
        return (Class)this.rootTagMap.get(qn);
    }

    public final Class getRootElement(String namespaceUri, String localName) {
        Class intfCls = this.lookupRootMap(namespaceUri, localName);
        if (intfCls == null) {
            return null;
        }
        return this.getDefaultImplementation(intfCls);
    }

    public final UnmarshallingEventHandler createUnmarshaller(String namespaceUri, String localName, UnmarshallingContext context) {
        Class impl = this.getRootElement(namespaceUri, localName);
        if (impl == null) {
            return null;
        }
        try {
            return ((UnmarshallableObject)impl.newInstance()).createUnmarshaller(context);
        }
        catch (InstantiationException e) {
            throw new InstantiationError(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.toString());
        }
    }

    public final String[] getProbePoints() {
        ArrayList<String> r = new ArrayList<String>();
        Iterator itr = this.rootTagMap.keySet().iterator();
        while (itr.hasNext()) {
            QName qn = (QName)itr.next();
            r.add(qn.getNamespaceURI());
            r.add(qn.getLocalPart());
        }
        return r.toArray(new String[r.size()]);
    }

    public final boolean recognize(String nsUri, String localName) {
        return this.lookupRootMap(nsUri, localName) != null;
    }

    public final Class getDefaultImplementation(Class javaContentInterface) {
        try {
            return Class.forName((String)this.defaultImplementationMap.get(javaContentInterface), true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.toString());
        }
    }

    public XMLSerializable castToXMLSerializable(Object o) {
        if (o instanceof XMLSerializable) {
            return (XMLSerializable)o;
        }
        return null;
    }
}

