/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax.parser;

public class ParserUtils {
    public static byte[] fromHexBinary(String s) {
        int len = s.length();
        if (len % 2 != 0) {
            return null;
        }
        byte[] out = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            int h = ParserUtils.hexToBin(s.charAt(i));
            int l = ParserUtils.hexToBin(s.charAt(i + 1));
            if (h == -1 || l == -1) {
                return null;
            }
            out[i / 2] = (byte)(h * 16 + l);
        }
        return out;
    }

    public static String collapseWhiteSpace(String text) {
        int s;
        int len = text.length();
        for (s = 0; s < len && !ParserUtils.isWhiteSpace(text.charAt(s)); ++s) {
        }
        if (s == len) {
            return text;
        }
        StringBuffer result = new StringBuffer(len);
        if (s != 0) {
            for (int i = 0; i < s; ++i) {
                result.append(text.charAt(i));
            }
            result.append(' ');
        }
        boolean inStripMode = true;
        for (int i = s + 1; i < len; ++i) {
            char ch = text.charAt(i);
            boolean b = ParserUtils.isWhiteSpace(ch);
            if (inStripMode && b) continue;
            inStripMode = b;
            if (inStripMode) {
                result.append(' ');
                continue;
            }
            result.append(ch);
        }
        len = result.length();
        if (len > 0 && result.charAt(len - 1) == ' ') {
            result.setLength(len - 1);
        }
        return result.toString();
    }

    private static final boolean isWhiteSpace(char ch) {
        if (ch > ' ') {
            return false;
        }
        return ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ';
    }

    private static int hexToBin(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        if ('A' <= ch && ch <= 'F') {
            return ch - 65 + 10;
        }
        if ('a' <= ch && ch <= 'f') {
            return ch - 97 + 10;
        }
        return -1;
    }
}

