/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax.parser;

import java.io.CharArrayWriter;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import phex.xml.sax.DPhex;
import phex.xml.sax.DSubElementList;
import phex.xml.sax.DUpdateResponse;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.parser.UpdateResponseHandler;
import phex.xml.sax.parser.favorites.FavoritesListHandler;
import phex.xml.sax.parser.gui.GuiSettingsHandler;
import phex.xml.sax.parser.rules.SearchRuleListHandler;
import phex.xml.sax.parser.share.SharedLibraryHandler;
import phex.xml.sax.share.DSharedLibrary;

public class PhexSAXHandler
extends DefaultHandler {
    private static final String PHEX_ELEMENT = "phex";
    private CharArrayWriter text = new CharArrayWriter();
    private SAXParser parser;
    private DPhex dPhex;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PhexSAXHandler(DPhex dPhex, SAXParser parser) {
        this.dPhex = dPhex;
        this.parser = parser;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.text.reset();
        if (PHEX_ELEMENT.equals(qName)) {
            String phexVersion = attributes.getValue("phex-version");
            this.dPhex.setPhexVersion(phexVersion);
        } else if (qName.equals("update-response")) {
            DUpdateResponse dResponse = new DUpdateResponse();
            this.dPhex.setUpdateResponse(dResponse);
            UpdateResponseHandler handler = new UpdateResponseHandler(dResponse, attributes, this, this.parser);
            this.parser.getXMLReader().setContentHandler(handler);
        } else if (qName.equals("update-request")) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"We should not pare update-request");
            }
        } else if (qName.equals("sharedLibrary")) {
            DSharedLibrary sharedLib = new DSharedLibrary();
            this.dPhex.setSharedLibrary(sharedLib);
            SharedLibraryHandler handler = new SharedLibraryHandler(sharedLib, this, this.parser);
            this.parser.getXMLReader().setContentHandler(handler);
        } else if (qName.equals("gui-settings")) {
            DGuiSettings dGui = new DGuiSettings();
            this.dPhex.setGuiSettings(dGui);
            GuiSettingsHandler handler = new GuiSettingsHandler(dGui, this, this.parser);
            this.parser.getXMLReader().setContentHandler(handler);
        } else if (qName.equals("favorites-list")) {
            DSubElementList favoritsList = new DSubElementList("favorites-list");
            this.dPhex.setFavoritesList(favoritsList);
            FavoritesListHandler handler = new FavoritesListHandler(favoritsList, this, this.parser);
            this.parser.getXMLReader().setContentHandler(handler);
        } else if (qName.equals("search-rule-list")) {
            DSubElementList ruleList = new DSubElementList("search-rule-list");
            this.dPhex.setSearchRuleList(ruleList);
            SearchRuleListHandler handler = new SearchRuleListHandler(ruleList, this, this.parser);
            this.parser.getXMLReader().setContentHandler(handler);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        return null;
    }

    public void characters(char[] ch, int start, int length) {
        this.text.write(ch, start, length);
    }

    static {
        $assertionsDisabled = !PhexSAXHandler.class.desiredAssertionStatus();
    }
}

