/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax.parser.gui;

import java.io.CharArrayWriter;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import phex.utils.NLogger;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTab;
import phex.xml.sax.gui.DTableList;
import phex.xml.sax.parser.gui.GuiTabHandler;
import phex.xml.sax.parser.gui.GuiTableListHandler;
import phex.xml.sax.parser.share.SharedFileHandler;

public class GuiSettingsHandler
extends DefaultHandler {
    public static final String THIS_TAG_NAME = "gui-settings";
    private CharArrayWriter text = new CharArrayWriter();
    private SAXParser parser;
    private DGuiSettings dGui;
    private DefaultHandler parent;

    public GuiSettingsHandler(DGuiSettings dGui, DefaultHandler parent, SAXParser parser) {
        this.dGui = dGui;
        this.parser = parser;
        this.parent = parent;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.text.reset();
        if (qName.equals("tab")) {
            DTab tab = new DTab();
            this.dGui.getTabList().add(tab);
            GuiTabHandler handler = new GuiTabHandler(tab, attributes, this, this.parser);
            this.parser.getXMLReader().setContentHandler(handler);
        } else if (qName.equals("table-list")) {
            DTableList tables = new DTableList();
            this.dGui.setTableList(tables);
            GuiTableListHandler handler = new GuiTableListHandler(tables, attributes, this, this.parser);
            this.parser.getXMLReader().setContentHandler(handler);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("look-and-feel-class")) {
            this.dGui.setLookAndFeelClass(this.text.toString());
        } else if (qName.equals("is-toolbar-visible")) {
            this.dGui.setToolbarVisible(Boolean.valueOf(this.text.toString()));
        } else if (qName.equals("is-statusbar-visible")) {
            this.dGui.setStatusbarVisible(Boolean.valueOf(this.text.toString()));
        } else if (qName.equals("is-searchbar-visible")) {
            this.dGui.setSearchBarVisible(Boolean.valueOf(this.text.toString()));
        } else if (qName.equals("is-searchlist-visible")) {
            this.dGui.setSearchListVisible(Boolean.valueOf(this.text.toString()));
        } else if (qName.equals("is-searchfilterpanel-visible")) {
            this.dGui.setSearchFilterPanelVisible(Boolean.valueOf(this.text.toString()));
        } else if (qName.equals("is-log-bandwidth-slider-used")) {
            this.dGui.setLogBandwidthSliderUsed(Boolean.valueOf(this.text.toString()));
        } else if (qName.equals("show-respect-copyright-notice")) {
            this.dGui.setShowRespectCopyrightNotice(Boolean.valueOf(this.text.toString()));
        } else if (qName.equals("window-posX")) {
            try {
                this.dGui.setWindowPosX(Integer.parseInt(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(SharedFileHandler.class, (Object)exp, (Throwable)exp);
            }
        } else if (qName.equals("window-posY")) {
            try {
                this.dGui.setWindowPosY(Integer.parseInt(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(SharedFileHandler.class, (Object)exp, (Throwable)exp);
            }
        } else if (qName.equals("window-width")) {
            try {
                this.dGui.setWindowWidth(Integer.parseInt(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(SharedFileHandler.class, (Object)exp, (Throwable)exp);
            }
        } else if (qName.equals("window-height")) {
            try {
                this.dGui.setWindowHeight(Integer.parseInt(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(SharedFileHandler.class, (Object)exp, (Throwable)exp);
            }
        } else if (qName.equals(THIS_TAG_NAME)) {
            this.parser.getXMLReader().setContentHandler(this.parent);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        return null;
    }

    public void characters(char[] ch, int start, int length) {
        this.text.write(ch, start, length);
    }
}

