/*
 * Decompiled with CFR 0.152.
 */
package phex.test;

import java.util.HashSet;
import junit.framework.TestCase;
import phex.common.AltLocContainer;
import phex.common.AlternateLocation;
import phex.common.URN;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.http.HTTPHeader;

public class TestAlternateLocation
extends TestCase {
    private String privateUriResStr;
    private String wrongPortUriResStr;
    private String wrongIPUriResStr;
    private String wrongIPUriResStr2;
    private String noPortUriResStr;
    private String uriResStr;
    private String uriResStr2;
    private String urnStr;

    public TestAlternateLocation(String string) {
        super(string);
    }

    protected void setUp() {
        this.privateUriResStr = "http://10.0.0.2:6346/uri-res/N2R?urn:sha1:PLSTHIPQGSSZTS5FJUPAKUZWUGYQYPFB";
        this.wrongPortUriResStr = "http://1.1.1.1:0/uri-res/N2R?urn:sha1:PLSTHIPQGSSZTS5FJUPAKUZWUGYQYPFB";
        this.wrongIPUriResStr = "http://333.333.333.333:6346/uri-res/N2R?urn:sha1:PLSTHIPQGSSZTS5FJUPAKUZWUGYQYPFB";
        this.wrongIPUriResStr2 = "http://0.0.0.0:6346/uri-res/N2R?urn:sha1:PLSTHIPQGSSZTS5FJUPAKUZWUGYQYPFB";
        this.noPortUriResStr = "http://1.1.1.1/uri-res/N2R?urn:sha1:PLSTHIPQGSSZTS5FJUPAKUZWUGYQYPFB";
        this.uriResStr = "http://1.1.1.1:6346/uri-res/N2R?urn:sha1:PLSTHIPQGSSZTS5FJUPAKUZWUGYQYPFB";
        this.uriResStr2 = "http://1.1.1.1:6347/uri-res/N2R?urn:sha1:PLSTHIPQGSSZTS5FJUPAKUZWUGYQYPFB";
        this.urnStr = "urn:sha1:PLSTHIPQGSSZTS5FJUPAKUZWUGYQYPFB";
    }

    protected void tearDown() {
    }

    public void testConstructor() throws Exception {
    }

    public void testParse() {
        AlternateLocation alternateLocation = AlternateLocation.parseUriResAltLoc((String)this.uriResStr);
        TestAlternateLocation.assertEquals((String)"1.1.1.1", (String)alternateLocation.getHTTPString());
        alternateLocation = AlternateLocation.parseUriResAltLoc((String)this.uriResStr2);
        TestAlternateLocation.assertEquals((String)"1.1.1.1:6347", (String)alternateLocation.getHTTPString());
        String string = "http://123.123.123.123:6347/get/1/phex.zip 2002-04-30T08:30:00Z";
        alternateLocation = AlternateLocation.parseUriResAltLoc((String)string);
        TestAlternateLocation.assertEquals(null, (Object)alternateLocation);
        string = this.privateUriResStr + " 2002-04-30T08:30:00Z";
        alternateLocation = AlternateLocation.parseUriResAltLoc((String)string);
        TestAlternateLocation.assertEquals(null, (Object)alternateLocation);
        string = this.wrongPortUriResStr + " 2002-04-30T08:30:00Z";
        alternateLocation = AlternateLocation.parseUriResAltLoc((String)string);
        TestAlternateLocation.assertEquals(null, (Object)alternateLocation);
        string = this.wrongIPUriResStr + " 2002-04-30T08:30:00Z";
        alternateLocation = AlternateLocation.parseUriResAltLoc((String)string);
        TestAlternateLocation.assertEquals(null, (Object)alternateLocation);
        string = this.wrongIPUriResStr2 + " 2002-04-30T08:30:00Z";
        alternateLocation = AlternateLocation.parseUriResAltLoc((String)string);
        TestAlternateLocation.assertEquals(null, (Object)alternateLocation);
        string = this.noPortUriResStr;
        alternateLocation = AlternateLocation.parseUriResAltLoc((String)string);
        TestAlternateLocation.assertEquals(null, (Object)alternateLocation);
        string = this.uriResStr.toUpperCase();
        alternateLocation = AlternateLocation.parseUriResAltLoc((String)string);
        TestAlternateLocation.assertNotNull((Object)alternateLocation);
        string = this.uriResStr + " 2002-04-30T08:30:00Z";
        alternateLocation = AlternateLocation.parseUriResAltLoc((String)string);
        TestAlternateLocation.assertEquals((String)"1.1.1.1", (String)alternateLocation.getHTTPString());
        string = this.uriResStr + " 2002-04-30T08:30Z";
        alternateLocation = AlternateLocation.parseUriResAltLoc((String)string);
        TestAlternateLocation.assertEquals((String)"1.1.1.1", (String)alternateLocation.getHTTPString());
    }

    public void testAlternateLocationContainer() throws Exception {
        Object object;
        AltLocContainer altLocContainer = new AltLocContainer(new URN(this.urnStr));
        AlternateLocation alternateLocation = AlternateLocation.parseUriResAltLoc((String)"http://1.1.1.1:6347/uri-res/N2R?urn:sha1:PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP");
        TestAlternateLocation.assertNotNull((Object)alternateLocation);
        altLocContainer.addAlternateLocation(alternateLocation);
        TestAlternateLocation.assertEquals((int)0, (int)altLocContainer.getSize());
        for (int i = 0; i < 130; ++i) {
            object = "http://1.1.1." + i + ":6347/uri-res/N2R?urn:sha1:PLSTHIPQGSSZTS5FJUPAKUZWUGYQYPFB 2002-04-30T08:30:" + i % 60 + "Z";
            alternateLocation = AlternateLocation.parseUriResAltLoc((String)object);
            TestAlternateLocation.assertNotNull((Object)alternateLocation);
            altLocContainer.addAlternateLocation(alternateLocation);
            TestAlternateLocation.assertEquals((int)Math.min(i + 1, 100), (int)altLocContainer.getSize());
        }
        HashSet hashSet = new HashSet();
        object = altLocContainer.getAltLocHTTPHeaderForAddress("X-Alt", (DestAddress)new DefaultDestAddress("1.1.1.10", 6347), hashSet);
        TestAlternateLocation.assertEquals((int)10, (int)AltLocContainer.parseCompactIpAltLocFromHeaders((HTTPHeader[])new HTTPHeader[]{object}, (URN)new URN(this.urnStr)).size());
        TestAlternateLocation.assertEquals((int)10, (int)hashSet.size());
        hashSet.clear();
        object = altLocContainer.getAltLocHTTPHeaderForAddress("X-Alt", (DestAddress)new DefaultDestAddress("2.1.1.1", 6347), hashSet);
        TestAlternateLocation.assertEquals((int)10, (int)AltLocContainer.parseCompactIpAltLocFromHeaders((HTTPHeader[])new HTTPHeader[]{object}, (URN)new URN(this.urnStr)).size());
        TestAlternateLocation.assertEquals((int)10, (int)hashSet.size());
        altLocContainer = new AltLocContainer(new URN(this.urnStr));
        alternateLocation = AlternateLocation.parseUriResAltLoc((String)"http://1.1.1.2:6347/uri-res/N2R?urn:sha1:PLSTHIPQGSSZTS5FJUPAKUZWUGYQYPFB");
        TestAlternateLocation.assertNotNull((Object)alternateLocation);
        altLocContainer.addAlternateLocation(alternateLocation);
        hashSet.clear();
        object = altLocContainer.getAltLocHTTPHeaderForAddress("X-Alt", (DestAddress)new DefaultDestAddress("1.1.1.2", 6347), hashSet);
        TestAlternateLocation.assertNull((Object)object);
        hashSet.clear();
        object = altLocContainer.getAltLocHTTPHeaderForAddress("X-Alt", (DestAddress)new DefaultDestAddress("2.1.1.1", 6347), hashSet);
        TestAlternateLocation.assertEquals((int)1, (int)AltLocContainer.parseCompactIpAltLocFromHeaders((HTTPHeader[])new HTTPHeader[]{object}, (URN)new URN(this.urnStr)).size());
        TestAlternateLocation.assertEquals((int)1, (int)hashSet.size());
        altLocContainer = new AltLocContainer(new URN(this.urnStr));
        alternateLocation = AlternateLocation.parseUriResAltLoc((String)"http://1.1.1.2:6347/uri-res/N2R?urn:sha1:PLSTHIPQGSSZTS5FJUPAKUZWUGYQYPFB 2002-04-30T08:30:10Z");
        TestAlternateLocation.assertNotNull((Object)alternateLocation);
        altLocContainer.addAlternateLocation(alternateLocation);
        alternateLocation = AlternateLocation.parseUriResAltLoc((String)"http://1.1.1.2:6347/uri-res/N2R?urn:sha1:PLSTHIPQGSSZTS5FJUPAKUZWUGYQYPFB 2002-04-30T08:30:11Z");
        TestAlternateLocation.assertNotNull((Object)alternateLocation);
        altLocContainer.addAlternateLocation(alternateLocation);
        TestAlternateLocation.assertEquals((int)1, (int)altLocContainer.getSize());
        hashSet.clear();
        object = altLocContainer.getAltLocHTTPHeaderForAddress("X-Alt", (DestAddress)new DefaultDestAddress("1.1.1.2", 6347), hashSet);
        TestAlternateLocation.assertNull((Object)object);
        hashSet.clear();
        object = altLocContainer.getAltLocHTTPHeaderForAddress("X-Alt", (DestAddress)new DefaultDestAddress("2.1.1.1", 6347), hashSet);
        TestAlternateLocation.assertEquals((int)1, (int)AltLocContainer.parseCompactIpAltLocFromHeaders((HTTPHeader[])new HTTPHeader[]{object}, (URN)new URN(this.urnStr)).size());
        TestAlternateLocation.assertEquals((int)1, (int)hashSet.size());
        object = altLocContainer.getAltLocHTTPHeaderForAddress("X-Alt", (DestAddress)new DefaultDestAddress("2.1.1.1", 6347), hashSet);
        TestAlternateLocation.assertNull((Object)object);
        TestAlternateLocation.assertEquals((int)1, (int)hashSet.size());
    }
}

