/*
 * Decompiled with CFR 0.152.
 */
package phex.test;

import junit.framework.TestCase;
import phex.common.address.AddressUtils;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;

public class TestHostAddress
extends TestCase {
    public TestHostAddress(String string) {
        super(string);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testIPClass() {
        try {
            DefaultDestAddress defaultDestAddress;
            int n;
            for (n = 1; n < 128; ++n) {
                defaultDestAddress = new DefaultDestAddress(n + ".1.1.1", 80);
                TestHostAddress.assertEquals((String)String.valueOf(n), (byte)1, (byte)defaultDestAddress.getIpAddress().getIPClass());
            }
            for (n = 128; n < 192; ++n) {
                defaultDestAddress = new DefaultDestAddress(n + ".1.1.1", 80);
                TestHostAddress.assertEquals((String)String.valueOf(n), (byte)2, (byte)defaultDestAddress.getIpAddress().getIPClass());
            }
            for (n = 192; n < 224; ++n) {
                defaultDestAddress = new DefaultDestAddress(n + ".1.1.1", 80);
                TestHostAddress.assertEquals((String)String.valueOf(n), (byte)3, (byte)defaultDestAddress.getIpAddress().getIPClass());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            TestHostAddress.fail((String)exception.getMessage());
        }
    }

    public void testIsIPValid() throws Exception {
        DefaultDestAddress defaultDestAddress = new DefaultDestAddress("1.1.1.1", 80);
        TestHostAddress.assertTrue((boolean)defaultDestAddress.getIpAddress().isValidIP());
        defaultDestAddress = new DefaultDestAddress("130.130.130.130", 80);
        TestHostAddress.assertTrue((boolean)defaultDestAddress.getIpAddress().isValidIP());
        defaultDestAddress = new DefaultDestAddress("200.200.200.200", 80);
        TestHostAddress.assertTrue((boolean)defaultDestAddress.getIpAddress().isValidIP());
        defaultDestAddress = new DefaultDestAddress("1.0.0.0", 80);
        TestHostAddress.assertFalse((boolean)defaultDestAddress.getIpAddress().isValidIP());
        defaultDestAddress = new DefaultDestAddress("130.130.0.0", 80);
        TestHostAddress.assertFalse((boolean)defaultDestAddress.getIpAddress().isValidIP());
        defaultDestAddress = new DefaultDestAddress("200.200.200.0", 80);
        TestHostAddress.assertFalse((boolean)defaultDestAddress.getIpAddress().isValidIP());
        defaultDestAddress = new DefaultDestAddress("1.0.0.1", 80);
        TestHostAddress.assertTrue((boolean)defaultDestAddress.getIpAddress().isValidIP());
        defaultDestAddress = new DefaultDestAddress("1.0.1.0", 80);
        TestHostAddress.assertTrue((boolean)defaultDestAddress.getIpAddress().isValidIP());
        defaultDestAddress = new DefaultDestAddress("1.1.0.0", 80);
        TestHostAddress.assertTrue((boolean)defaultDestAddress.getIpAddress().isValidIP());
        defaultDestAddress = new DefaultDestAddress("130.0.0.1", 80);
        TestHostAddress.assertTrue((boolean)defaultDestAddress.getIpAddress().isValidIP());
        defaultDestAddress = new DefaultDestAddress("130.0.1.0", 80);
        TestHostAddress.assertTrue((boolean)defaultDestAddress.getIpAddress().isValidIP());
        defaultDestAddress = new DefaultDestAddress("200.0.0.1", 80);
        TestHostAddress.assertTrue((boolean)defaultDestAddress.getIpAddress().isValidIP());
        defaultDestAddress = new DefaultDestAddress("0.0.0.0", 80);
        TestHostAddress.assertFalse((boolean)defaultDestAddress.getIpAddress().isValidIP());
        defaultDestAddress = new DefaultDestAddress("300.300.300.300", 80);
        TestHostAddress.assertFalse((boolean)defaultDestAddress.getIpAddress().isValidIP());
    }

    public void testHashEquals() {
        try {
            DefaultDestAddress defaultDestAddress = new DefaultDestAddress("127.0.0.1", 4444);
            DefaultDestAddress defaultDestAddress2 = new DefaultDestAddress("127.0.0.1", 4444);
            boolean bl = defaultDestAddress.equals((DestAddress)defaultDestAddress2);
            TestHostAddress.assertEquals((boolean)true, (boolean)bl);
            int n = defaultDestAddress.hashCode();
            int n2 = defaultDestAddress2.hashCode();
            TestHostAddress.assertEquals((int)n, (int)n2);
        }
        catch (Exception exception) {
            TestHostAddress.fail((String)exception.getMessage());
        }
    }

    public void testPortInRange() {
        TestHostAddress.assertEquals((boolean)false, (boolean)AddressUtils.isPortInRange((int)-1));
        TestHostAddress.assertEquals((boolean)false, (boolean)AddressUtils.isPortInRange((int)0));
        TestHostAddress.assertEquals((boolean)true, (boolean)AddressUtils.isPortInRange((int)1));
        TestHostAddress.assertEquals((boolean)true, (boolean)AddressUtils.isPortInRange((int)256));
        TestHostAddress.assertEquals((boolean)true, (boolean)AddressUtils.isPortInRange((int)13244));
        TestHostAddress.assertEquals((boolean)true, (boolean)AddressUtils.isPortInRange((int)65535));
    }

    public void testIpLookup() {
        DefaultDestAddress defaultDestAddress = new DefaultDestAddress("google.de", 80);
        defaultDestAddress.getIpAddress();
        defaultDestAddress.getIpAddress();
        defaultDestAddress.getIpAddress();
        defaultDestAddress.getIpAddress();
        defaultDestAddress.getIpAddress();
        defaultDestAddress.getIpAddress();
        defaultDestAddress.getIpAddress();
    }
}

