/*
 * Decompiled with CFR 0.152.
 */
package phex.test;

import java.io.InputStream;
import java.util.List;
import junit.framework.TestCase;
import phex.utils.MagmaParser;

public class TestMagmaParser
extends TestCase {
    public TestMagmaParser(String string) {
        super(string);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testValidMagma1() throws Throwable {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream("phex/test/resources/valid_magma_1.magma");
        MagmaParser magmaParser = new MagmaParser(inputStream);
        magmaParser.start();
        List list = magmaParser.getMagnets();
        TestMagmaParser.assertEquals((String)((String)list.get(0)), (String)"magnet:?xt=urn:sha1:2KQWDD47VSCDX6IM54NSEPSC44IB3NCG&dn=%28Kurzgeschichte%29+Arne+Babenhauserheide+-++Galactic-Tales+Estiala%2C+Vorgeschichte.txt");
        TestMagmaParser.assertEquals((int)119, (int)list.size());
        inputStream = ClassLoader.getSystemResourceAsStream("phex/test/resources/bracken_magma.magma");
        magmaParser = new MagmaParser(inputStream);
        magmaParser.start();
        list = magmaParser.getMagnets();
        TestMagmaParser.assertEquals((String)"magnet:?xt=urn:sha1:MCH2HGBTFRKMGH5LSVH5MKLCCBBQ7XAP&dn=Dildo%20Backenspalter.mp3&xs=http://dlaikar.de/arnebab/musik/dildo-backenspalter.mp3", (String)((String)list.get(0)));
        TestMagmaParser.assertEquals((String)"magnet:?xt=urn:sha1:<another+hash>&dn=<another+filename>&xs=<another+exact+substitute>", (String)((String)list.get(1)));
        TestMagmaParser.assertEquals((String)"magnet:?xt=urn:sha1:PX2AN5FPSJGORDBQ2YIV3LRR2SRLP5LY&dn=A%20Curse%20upon%20those%20Parents.mp3&xs=http://10.0.1.3:6346/uri-res/N2R?urn:sha1:PX2AN5FPSJGORDBQ2YIV3LRR2SRLP5LY", (String)((String)list.get(2)));
        TestMagmaParser.assertEquals((String)"magnet?xt=urn:sha1:<some+hash>&dn=<some+filename>&xs=<another+source>", (String)((String)list.get(3)));
        TestMagmaParser.assertEquals((String)"magnet:?xt=urn:sha1:<some+hash>&dn=<some+name>", (String)((String)list.get(4)));
        TestMagmaParser.assertEquals((int)5, (int)list.size());
        inputStream = ClassLoader.getSystemResourceAsStream("phex/test/resources/magmatest.magma");
        magmaParser = new MagmaParser(inputStream);
        magmaParser.start();
        list = magmaParser.getMagnets();
        TestMagmaParser.assertEquals((String)"magnet:?xt=urn:sha1:OW2VBA5SXFAIYGOUK3DZLB4GSQZWEPOF&dn=MagmaTestv0.2.zip&xs=http://edrikor.dyndns.org:9845/uri-res/N2R?urn:sha1:OW2VBA5SXFAIYGOUK3DZLB4GSQZWEPOF", (String)((String)list.get(0)));
        TestMagmaParser.assertEquals((String)"magnet:?xt=urn:sha1:NTZTRLWMX4EY7AZS2LMLZKCHN2SX4LCG&dn=MagmaTestv0.31.zip&xs=http://edrikor.dyndns.org:9845/uri-res/N2R?urn:sha1:NTZTRLWMX4EY7AZS2LMLZKCHN2SX4LCG", (String)((String)list.get(1)));
        TestMagmaParser.assertEquals((String)"magnet:?xt=urn:sha1:LRZEJB5FGJECKR6NBY2LNTFWZAOL5FWN&dn=MagmaTestv0.36.zip&xs=http://edrikor.dyndns.org:9845/uri-res/N2R?urn:sha1:LRZEJB5FGJECKR6NBY2LNTFWZAOL5FWN", (String)((String)list.get(4)));
        TestMagmaParser.assertEquals((String)"magnet:?xt=urn:sha1:KK2TVAVPGKAGI73NRVIBBYPWCOAC7OYY&dn=MagmaTest-OSX-v0.36.jar.zip&xs=http://edrikor.dyndns.org:9845/uri-res/N2R?urn:sha1:KK2TVAVPGKAGI73NRVIBBYPWCOAC7OYY", (String)((String)list.get(5)));
        TestMagmaParser.assertEquals((int)6, (int)list.size());
    }
}

