/*
 * Decompiled with CFR 0.152.
 */
package phex.test;

import java.net.Socket;
import junit.framework.TestCase;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.host.Host;
import phex.msg.GUID;
import phex.msg.MsgManager;
import phex.net.connection.Connection;
import phex.net.presentation.SocketFacade;
import phex.net.presentation.def.DefaultSocketFacade;
import phex.utils.QueryGUIDRoutingPair;

public class TestMsgManager
extends TestCase {
    private MsgManager msgmanager;

    public TestMsgManager(String string) {
        super(string);
    }

    protected void setUp() {
        this.msgmanager = MsgManager.getInstance();
    }

    protected void tearDown() {
    }

    public void testAddToPushRoutingTable() throws Exception {
        GUID gUID = new GUID();
        Host host = new Host((DestAddress)new DefaultDestAddress("1.1.1.1", 1111));
        host.setConnection(new Connection((SocketFacade)new DummySocket(), null));
        this.msgmanager.addToPushRoutingTable(gUID, host);
        Host host2 = this.msgmanager.getPushRouting(gUID);
        TestMsgManager.assertEquals((Object)host, (Object)host2);
    }

    public void testCheckAndAddToPingRoutingTable() throws Exception {
        GUID gUID = new GUID();
        Host host = new Host((DestAddress)new DefaultDestAddress("2.2.2.2", 2222));
        host.setConnection(new Connection((SocketFacade)new DummySocket(), null));
        boolean bl = this.msgmanager.checkAndAddToPingRoutingTable(gUID, host);
        TestMsgManager.assertEquals((boolean)true, (boolean)bl);
        bl = this.msgmanager.checkAndAddToPingRoutingTable(gUID, host);
        TestMsgManager.assertEquals((boolean)false, (boolean)bl);
        Host host2 = this.msgmanager.getPingRouting(gUID);
        TestMsgManager.assertEquals((Object)host, (Object)host2);
    }

    public void testCheckAndAddToQueryRoutingTable() throws Exception {
        GUID gUID = new GUID();
        Host host = new Host((DestAddress)new DefaultDestAddress("3.3.3.3", 3333));
        host.setConnection(new Connection((SocketFacade)new DummySocket(), null));
        boolean bl = this.msgmanager.checkAndAddToQueryRoutingTable(gUID, host);
        TestMsgManager.assertEquals((boolean)true, (boolean)bl);
        bl = this.msgmanager.checkAndAddToQueryRoutingTable(gUID, host);
        TestMsgManager.assertEquals((boolean)false, (boolean)bl);
        QueryGUIDRoutingPair queryGUIDRoutingPair = this.msgmanager.getQueryRouting(gUID, 0);
        TestMsgManager.assertEquals((Object)host, (Object)queryGUIDRoutingPair.getHost());
    }

    private class DummySocket
    extends DefaultSocketFacade {
        DummySocket() {
            super(new Socket());
        }
    }
}

