/*
 * Decompiled with CFR 0.152.
 */
package phex.test;

import java.util.BitSet;
import java.util.Iterator;
import junit.framework.TestCase;
import phex.common.QueryRoutingTable;
import phex.msg.InvalidMessageException;
import phex.msg.QRPatchTableMsg;
import phex.msg.QRResetTableMsg;
import phex.msg.QueryMsg;
import phex.msg.RouteTableUpdateMsg;
import phex.test.AccessUtils;

public class TestQueryRoutingTable
extends TestCase {
    private QueryRoutingTable qrTable;

    public TestQueryRoutingTable(String string) {
        super(string);
    }

    protected void setUp() {
        this.qrTable = new QueryRoutingTable();
        try {
            AccessUtils.invokeMethod((Object)this.qrTable, "addWord", "phex");
            AccessUtils.invokeMethod((Object)this.qrTable, "addWord", "java");
            AccessUtils.invokeMethod((Object)this.qrTable, "add", "test query route table");
            AccessUtils.invokeMethod((Object)this.qrTable, "add", "ExtendedWord");
            AccessUtils.invokeMethod((Object)this.qrTable, "add", "javafo");
        }
        catch (Throwable throwable) {
            TestQueryRoutingTable.fail();
        }
    }

    protected void tearDown() {
    }

    public void testElementCount() {
        Integer n = (Integer)AccessUtils.getFieldValue(this.qrTable, "entryCount");
        TestQueryRoutingTable.assertEquals((int)12, (int)n);
    }

    public void testContainsQueryString() {
        String[] stringArray = new String[]{"phex", "java", "route", "test query table", "ExtendedWord", "Extended", "ExtendedWor", "ExtendedWo phex"};
        QueryMsg queryMsg = new QueryMsg(7, "", null, false, false);
        for (int i = 0; i < stringArray.length; ++i) {
            AccessUtils.setFieldValue(queryMsg, "searchString", stringArray[i]);
            TestQueryRoutingTable.assertTrue((boolean)this.qrTable.containsQuery(queryMsg));
        }
        String[] stringArray2 = new String[]{"wrong", "test query table wrong"};
        for (int i = 0; i < stringArray2.length; ++i) {
            AccessUtils.setFieldValue(queryMsg, "searchString", stringArray2[i]);
            TestQueryRoutingTable.assertFalse((boolean)this.qrTable.containsQuery(queryMsg));
        }
    }

    public void testQRTInitMessages() {
        Iterator iterator = QueryRoutingTable.buildRouteTableUpdateMsgIterator((QueryRoutingTable)this.qrTable, null);
        Object e = iterator.next();
        TestQueryRoutingTable.assertTrue((boolean)(e instanceof QRResetTableMsg));
        e = iterator.next();
        TestQueryRoutingTable.assertTrue((boolean)(e instanceof QRPatchTableMsg));
    }

    public void testBuildAndUpdate() throws InvalidMessageException {
        Object object;
        Iterator iterator = QueryRoutingTable.buildRouteTableUpdateMsgIterator((QueryRoutingTable)this.qrTable, null);
        QueryRoutingTable queryRoutingTable = new QueryRoutingTable();
        while (iterator.hasNext()) {
            object = (RouteTableUpdateMsg)iterator.next();
            queryRoutingTable.updateRouteTable(object);
        }
        object = (BitSet)AccessUtils.getFieldValue(this.qrTable, "qrTable");
        BitSet bitSet = (BitSet)AccessUtils.getFieldValue(queryRoutingTable, "qrTable");
        TestQueryRoutingTable.assertTrue((String)("Found:\n" + bitSet + "\nExpected:\n" + object), (boolean)bitSet.equals(object));
    }
}

