/*
 * Decompiled with CFR 0.152.
 */
package phex.test.performance;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import junit.framework.TestCase;

public class TestFileCopy
extends TestCase {
    private File tempFile1;
    private RandomAccessFile raFile1;
    private static final int BUFFER_LENGTH = 262144;

    protected void setUp() throws Exception {
        super.setUp();
        this.tempFile1 = File.createTempFile("TestFileUtils1", "tmp");
        this.raFile1 = new RandomAccessFile(this.tempFile1, "rw");
        this.raFile1.setLength(0x1E00000L);
        this.raFile1.close();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.tempFile1.delete();
    }

    public void testCopy() throws Exception {
        File file = File.createTempFile("TestFileUtils2", "tmp");
        long l = System.currentTimeMillis();
        for (int i = 0; i < 5; ++i) {
            TestFileCopy.copyFile(this.tempFile1, file);
        }
        file.delete();
        long l2 = System.currentTimeMillis();
        System.out.println("standard: " + (l2 - l));
    }

    public static void copyFile(File file, File file2) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        byte[] byArray = new byte[(int)Math.min(262144L, file.length() + 1L)];
        while ((n = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedOutputStream.close();
        bufferedInputStream.close();
    }
}

