/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2006 Phex Development Group
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  Created on 17.03.2006
 *  --- CVS Information ---
 *  $Id$
 */
package phex.gui.common.statusbar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Timer;

import phex.utils.NLogger;
import phex.utils.NLoggerNames;

public class MainStatusBar extends StatusBar
{   
    private Timer updateTimer;

    public MainStatusBar()
    {
        super();
        addZone("ConnectionsZone", new ConnectionsZone(), "*");
        addZone("DownloadZone", new DownloadZone(), "");
        addZone("UploadZone", new UploadZone(), "");
    }
    
    public void removeNotify()
    {
        super.removeNotify();
        updateTimer.stop();
    }
    
    public void addNotify()
    {
        super.addNotify();
        if ( updateTimer == null )
        {
            updateTimer = new Timer( 2000, new UpdateAction() );
        }
        updateTimer.start();
    }
    
    private final class UpdateAction implements ActionListener
    {
        public void actionPerformed( ActionEvent e )
        {
            try
            {
                ((ConnectionsZone)getZone("ConnectionsZone")).updateZone();
                ((DownloadZone)getZone("DownloadZone")).updateZone();
                ((UploadZone)getZone("UploadZone")).updateZone();
            }
            catch ( Throwable th )
            {
                NLogger.error(NLoggerNames.USER_INTERFACE, th, th);
            }
        }
    }
}
