/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2006 Phex Development Group
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  Created on 06.03.2006
 *  --- CVS Information ---
 *  $Id: SearchVisualizer.java 3362 2006-03-30 22:27:26Z gregork $
 */
package phex.gui.tabs.search;

import phex.query.*;
import phex.utils.Localizer;

public class SearchVisualizer
{
    public static String visualizeSearchStatus( Search search )
    {
        if ( search instanceof BrowseHostResults )
        {
            BrowseHostResults br = (BrowseHostResults) search;
            switch ( br.getBrowseHostStatus() )
            {
            case BrowseHostResults.INITIALIZING:
                return Localizer.getString("BrowseHost_Initializing");
            case BrowseHostResults.CONNECTING:
                return Localizer.getString("BrowseHost_Connecting");
            case BrowseHostResults.FETCHING:
                return Localizer.getString("BrowseHost_Fetching");
            case BrowseHostResults.FINISHED:
                return Localizer.getString("BrowseHost_Finished");
            case BrowseHostResults.CONNECTION_ERROR:
                return Localizer.getString("BrowseHost_ConnectionError");
            case BrowseHostResults.BROWSE_HOST_ERROR:
                return Localizer.getString("BrowseHost_BrowseHostError");
            default:
                return "Unknown: " + br.getBrowseHostStatus();
            }
        }
        else
        {
            if (search.isSearching())
            {
                return Localizer.getString("Searching");
            }
            else
            {
                return Localizer.getString("Search_Stopped");
            }
        }
    }
}
