/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2006 Phex Development Group
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  Created on 05.03.2005
 *  --- CVS Information ---
 *  $Id: ConnectionFactory.java 3362 2006-03-30 22:27:26Z gregork $
 */
package phex.net.connection;

import java.io.IOException;

import phex.common.address.DestAddress;
import phex.common.bandwidth.BandwidthManager;
import phex.net.presentation.SocketFacade;

/**
 *
 */
public class ConnectionFactory
{
    private ConnectionFactory()
    {}
    
    /**
     * Creates a connection to the given host and port with Cfg.socketConnectTimeout.
     * The connection returned will use as default the network bandwidth controller 
     * and the Cfg.socketRWTimeout as the read/write timeout.
     * 
     * @param address the host address to connect.
     * @return a connection
     * @throws IOException in case an connection error occures.
     */
    public static Connection createConnection( DestAddress address )
        throws IOException
    {
        SocketFacade socket = OIOSocketFactory.connect( address );        
        Connection connection = new Connection( socket, 
            BandwidthManager.getInstance().getNetworkBandwidthController() );
        
        return connection;
    }
    
    /**
     * Creates a connection to the given host and port with Cfg.socketConnectTimeout.
     * The connection returned will use as default the network bandwidth controller 
     * and the Cfg.socketRWTimeout as the read/write timeout.
     * 
     * @param address the host address to connect.
     * @param connectTimeout the connect timeout in millis
     * @return a connection
     * @throws IOException in case an connection error occures.
     */
    public static Connection createConnection( DestAddress address, int connectTimeout )
        throws IOException
    {
        SocketFacade socket = OIOSocketFactory.connect( address, connectTimeout );
        Connection connection = new Connection( socket, 
            BandwidthManager.getInstance().getNetworkBandwidthController() );
        
        return connection;
    }
}
