/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2006 Phex Development Group
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  --- CVS Information ---
 *  $Id: TestFullXJBTree.java 3362 2006-03-30 22:27:26Z gregork $
 */
package phex.test;

import java.io.File;

import junit.framework.TestCase;
import phex.common.file.FileManager;
import phex.common.file.ManagedFile;
import phex.xml.*;


public class TestFullXJBTree extends TestCase
{

    public TestFullXJBTree(String s)
    {
        super(s);
    }

    protected void setUp()
    {
    }

    protected void tearDown()
    {
    }

    public void testXJBSaveToFile()
    {
        try
        {
            ObjectFactory objFactory = new ObjectFactory();
            
            XJBPhex xjbPhex = objFactory.createPhexElement();
            
            xjbPhex.setPhexVersion("1.2.3");
                        
            XJBSecurity security = objFactory.createXJBSecurity();
            XJBIPAccessRule iprule = objFactory.createXJBIPAccessRule();
            iprule.setAddressType((byte)1);
            iprule.setCompareIP(new byte[] {1,1,1,1});
            iprule.setDeletedOnExpiry(false);
            iprule.setDenyingRule(true);
            iprule.setDescription("test");
            iprule.setDisabled(false);
            iprule.setExpiryDate(1234567l);
            iprule.setIp(new byte[] {1,1,1,1});
            iprule.setSystemRule(true);
            iprule.setTriggerCount(123);
            security.getIpAccessRuleList().add(iprule);
            xjbPhex.setSecurity(security);
            
            XJBSWDownloadList downList = objFactory.createXJBSWDownloadList();
            XJBSWDownloadFile downFile = objFactory.createXJBSWDownloadFile();
            downFile.setCreatedTime(1234567l);
            downFile.setFileSize(1234567l);
            downFile.setFileURN("test");
            downFile.setLocalFileName("test");
            downFile.setModifiedTime(1234567l);
            downFile.setSearchTerm("test");
            downFile.setStatus((short)123);
            XJBSWDownloadCandidate downCandidate = objFactory.createXJBSWDownloadCandidate();
            downCandidate.setChatSupported(false);
            downCandidate.setConnectionFailedRepetition(123);
            downCandidate.setFileIndex(1234567l);
            downCandidate.setFileName("test");
            downCandidate.setGUID("test");
            downCandidate.setPushNeeded(true);
            downCandidate.setRemoteHost("test");
            downCandidate.setThexSupported(false);
            downCandidate.setVendor("test");
            downFile.getCandidateList().add(downCandidate);
            XJBSWDownloadSegment segment = objFactory.createXJBSWDownloadSegment();
            segment.setIncompleteFileName("test");
            segment.setLength(1234567l);
            segment.setSegmentNumber(123);
            segment.setStartPosition(1234567l);
            downFile.getSegmentList().add(segment);
            downList.getSWDownloadFileList().add(downFile);
            xjbPhex.setSWDownloadList(downList);
            
            
            XJBUpdateResponse response = objFactory.createXJBUpdateResponse();
            XJBUpdateResponse.InfoType info = objFactory.createXJBUpdateResponseInfoType();
            info.setHeader("test");
            info.setId("test");
            info.setText("test");
            response.getInfoList().add(info);
            XJBUpdateResponse.VersionType version = objFactory.createXJBUpdateResponseVersionType();
            version.setBeta(false);
            version.setId("test");
            version.setText("test");
            response.getVersionList().add(version);
            xjbPhex.setUpdateResponse(response);
            
            
            File aFile1 = new File( "c:\\temp\\tempXJB.xml" );
            ManagedFile managedFile = FileManager.getInstance().getReadWriteManagedFile( aFile1 );
            XMLBuilder.saveToFile( managedFile, xjbPhex );
        }
        catch(Exception e)
        {
            System.err.println("Exception thrown:  "+e);
        }
    }

    public void testLoadXJBPhexFromFile()
    {
        long startMem = Runtime.getRuntime().totalMemory();
        long start = System.currentTimeMillis();
       File aFile1 = new File( "c:\\temp\\tempXJB.xml" );
       try
       {
           ManagedFile managedFile = FileManager.getInstance().getReadWriteManagedFile( aFile1 );
           XJBPhex xjbphexRet = XMLBuilder.loadXJBPhexFromFile( managedFile );
       }
       catch(Exception e) {
           System.err.println("Exception thrown:  "+e);
       }
       long end = System.currentTimeMillis();
        long endMem = Runtime.getRuntime().totalMemory();
        System.out.println( "parsexjb: " + (end-start) + " " + ( endMem - startMem) );
   }
}