/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2006 Phex Development Group
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  --- CVS Information ---
 *  $Id: SubscriptionDownloader.java 3400 2006-04-23 06:52:04Z arnebab $
 */
package phex.utils;

import java.io.*;
import java.util.*;

import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;

import phex.common.Cfg;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.common.Environment;
import phex.connection.NetworkManager;
import phex.download.MagnetData;
import phex.download.swarming.SwarmingManager;

 
public class SubscriptionDownloader extends TimerTask
{	
	public SubscriptionDownloader()
	{
		Environment.getInstance().scheduleTimerTask( this, 0, 48 * 3600 * 1000 ); 
	}
	public void run()
	{
		List subscriptionMagnets = loadSubscriptionList(); 
		String uriStr;  
		Iterator iterator = subscriptionMagnets.iterator();
		while (iterator.hasNext())
    	{
        	uriStr = (String) iterator.next();
        	// createDownload(uriStr); //This would donwload the magma via magnet silently in the background. 
        	NetworkManager.getInstance().fireIncomingUriDownload(uriStr);
    	}
	}

    private List loadSubscriptionList()
    {
	String name = "/subscription.list";
        InputStream stream = SubscriptionDownloader.class.getResourceAsStream( name );
        if ( stream == null )
		{
			List subscriptionMagnets = ServiceManager.sCfg.subscriptionMagnets;
			List list = ServiceManager.sCfg.subscriptionMagnets; 
			if (subscriptionMagnets == null && Cfg.default_subscriptionMagnets != null)
			{
				subscriptionMagnets.add(Cfg.default_subscriptionMagnets); 
			}
			return list; 
		}
        try
        {
            // make sure it is buffered
            InputStreamReader input = new InputStreamReader( stream );
            BufferedReader reader = new BufferedReader(input);
            List list = new ArrayList();
            String line = reader.readLine();
            if ( line == null && Cfg.default_subscriptionMagnets != null )
			{
				list.add(Cfg.default_subscriptionMagnets); 
			}
            while (line != null) {
                list.add(line);
                line = reader.readLine();
            }
            return list;        
        }
        catch (IOException exp)
        {
            NLogger.warn(SubscriptionDownloader.class, exp);
        }
        finally
        {
            IOUtil.closeQuietly( stream );
        }
        return Collections.EMPTY_LIST;
    }

	
	private void createDownload(String uriStr) throws URIException
    {
    	
        if (uriStr.length() == 0)
        {
            return;
        }
        URI uri = new URI( uriStr, true );
        
        // dont add already downloading urns.
        MagnetData magnetData = MagnetData.parseFromURI(uri);
        URN urn = MagnetData.lookupSHA1URN(magnetData);
        SwarmingManager swarmingMgr = SwarmingManager.getInstance();
        if ( !swarmingMgr.isURNDownloaded( urn ) )
        {
            swarmingMgr.addFileToDownload( uri );
        }
    }
}
