package phex.xml.sax;

import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.share.DSharedLibrary;

public class DPhex
{
    private String phexVersion;

    //protected phex.xml.XJBSWDownloadList _SWDownloadList;
    //protected phex.xml.XJBSecurity _Security;
    private DUpdateRequest updateRequest;
    //protected phex.xml.XJBSearchFilters _SearchFilters;

    private DUpdateResponse updateResponse;
    private DSubElementList favoritesList;
    private DSubElementList searchRuleList;
    private DSharedLibrary sharedLibrary;
    private DGuiSettings guiSettings;

    
    public String getPhexVersion()
    {
        return phexVersion;
    }

    public void setPhexVersion( String value )
    {
        phexVersion = value;
    }

    public DSubElementList getFavoritesList()
    {
        return favoritesList;
    }

    public void setFavoritesList( DSubElementList value )
    {
        favoritesList = value;
    }

    public DSharedLibrary getSharedLibrary()
    {
        return sharedLibrary;
    }

    public void setSharedLibrary( DSharedLibrary value )
    {
        sharedLibrary = value;
    }

    public DUpdateResponse getUpdateResponse()
    {
        return updateResponse;
    }

    public void setUpdateResponse( DUpdateResponse value )
    {
        updateResponse = value;
    }

    public DUpdateRequest getUpdateRequest()
    {
        return updateRequest;
    }

    public void setUpdateRequest( DUpdateRequest value )
    {
        updateRequest = value;
    }

    public DSubElementList getSearchRuleList()
    {
        return searchRuleList;
    }

    public void setSearchRuleList( DSubElementList rulesList )
    {
        this.searchRuleList = rulesList;
    }

    public DGuiSettings getGuiSettings()
    {
        return guiSettings;
    }

    public void setGuiSettings( DGuiSettings guiSettings )
    {
        this.guiSettings = guiSettings;
    }

    public void serialize( PhexXmlSaxWriter writer ) throws SAXException
    {
        AttributesImpl attributes = null;
        if ( phexVersion != null )
        {
            attributes = new AttributesImpl();
            attributes.addAttribute( "", "", "phex-version", "CDATA",
                phexVersion );
        }
        writer.startElm( "phex", attributes );

        if ( updateRequest != null )
        {
            updateRequest.serialize( writer );
        }

        if ( favoritesList != null )
        {
            favoritesList.serialize( writer );
        }

        if ( searchRuleList != null )
        {
            searchRuleList.serialize( writer );
        }

        if ( sharedLibrary != null )
        {
            sharedLibrary.serialize( writer );
        }

        if ( guiSettings != null )
        {
            guiSettings.serialize( writer );
        }

        // we dont need to serialize update response

        writer.endElm( "phex" );
    }
}
