package phex.xml.sax;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.xml.sax.SAXException;

public class DSubElementList
{
    private String elementName;
    private List subElementList;
    
    public DSubElementList( String name )
    {
        elementName = name;
    }

    public List getSubElementList()
    {
        if ( subElementList == null )
        {
            subElementList = new ArrayList();
        }
        return subElementList;
    }

    public void serialize( PhexXmlSaxWriter writer )
        throws SAXException
    {
        writer.startElm( elementName, null );

        Iterator iterator = subElementList.iterator();
        while ( iterator.hasNext() )
        {
            DElement subElement = (DElement) iterator.next();
            subElement.serialize( writer );
        }

        writer.endElm( elementName );
    }
}
