/*
 * Copyright (C) 2007 Johan Dahlin
 *
 * All rights reserved
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 *
 */

#include <Python.h>
#include <pygtk/pygtk.h>

static void
gtk_settings_set_for_screen(GdkScreen *screen, GtkSettings* settings)
{
  settings->screen = screen;
  g_object_set_data(G_OBJECT(screen), "gtk-settings", settings);
}

static PyObject *
_wrap_gtk_settings_set_for_screen(PyObject *self, PyObject *args)
{
  PyGObject *py_screen, *py_settings;
  
  if (!PyArg_ParseTuple(args, "OO:", &py_screen, &py_settings))
    return NULL;

  gtk_settings_set_for_screen(GDK_SCREEN(py_screen->obj),
			      GTK_SETTINGS(py_settings->obj));

  Py_INCREF(Py_None);
  return Py_None;
}

static PyMethodDef _gtkhelper_functions[] = {
    { "gtk_settings_set_for_screen", _wrap_gtk_settings_set_for_screen,
      METH_VARARGS },
    { NULL, NULL, 0 }
};

void init_gtkhelper(void)
{
  init_pygtk();
  Py_InitModule("_gtkhelper", _gtkhelper_functions);
}
